/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Manager;
import com.ptteng.iqiyi.admin.service.ManagerService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ManagerController {
    private static final Logger log = LoggerFactory.getLogger(ManagerController.class);
    @Resource
    private ManagerService managerService;

    @GetMapping(value={"/a/u/manager/list"})
    public List<Manager> listManager(@RequestParam(name="roleID", required=false) Long roleID, @RequestParam(name="status", required=false) String status) {
        log.info("listManager roleId= {},status ={}", (Object)roleID, (Object)status);
        List managers = this.managerService.selectByRoleAndStatus(roleID, status);
        log.info("manager list=========" + managers.size());
        return managers;
    }

    @GetMapping(value={"/a/u/multi/manager"})
    public List<Manager> findListbyIds(@RequestParam(value="ids", required=true) List<Long> ids) {
        List managerList = this.managerService.findListbyIds(ids);
        log.info("managerList======" + managerList.size());
        return managerList;
    }

    @PostMapping(value={"/a/u/manager"})
    public Long addManager(@RequestBody Manager manager) {
        log.info("addManager==============", (Object)manager);
        Long mid = this.managerService.insertSelective(manager);
        log.info("addManager result========" + mid);
        return mid;
    }

    @DeleteMapping(value={"/a/u/manager/{mid}"})
    public boolean deleteManager(@PathVariable(value="mid") Long mid) {
        log.info("deleteManager=========" + mid);
        boolean result = this.managerService.deleteByPrimaryKey(mid);
        return result;
    }

    @PutMapping(value={"/a/u/manager/{id}"})
    public Long updateManager(@PathVariable(value="id") Long mid, @RequestBody Manager manager) {
        log.info("updateManager========" + manager);
        Long result = this.managerService.updateByPrimaryKeySelective(mid, manager);
        log.info("result==========" + result);
        return result;
    }

    @GetMapping(value={"/a/u/manager/{id}"})
    public Manager getById(@PathVariable(value="id") Long mid) {
        log.info("getById======={}" + mid);
        Manager manager = this.managerService.selectByPrimaryKey(mid);
        log.info("manager info={}", (Object)manager);
        return manager;
    }

    @GetMapping(value={"/a/u/manager/search"})
    public List<Manager> getByName(String name) {
        log.info("getByName=======" + name);
        List managers = this.managerService.selectByName(name);
        log.info("managers info={}", (Object)managers);
        return managers;
    }
}

