/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Game;
import com.ptteng.iqiyi.admin.service.GameService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GameController {
    private static final Logger log = LoggerFactory.getLogger(GameController.class);
    @Resource
    private GameService gameService;

    @PostMapping(value={"/a/u/app/{type}"})
    public Long saveGame(@PathVariable Integer type, @RequestBody Game game) {
        log.info("service\u6a21\u5757 \u65b0\u589egame \u5165\u53c2 evaluating = {}", (Object)game);
        Long id = this.gameService.saveGame(type, game);
        log.info("service\u6a21\u5757 \u65b0\u589egame \u6210\u529f id = {}", (Object)id);
        return id;
    }

    @DeleteMapping(value={"/a/u/app/{id}"})
    public Long deleteGame(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 \u5220\u9664game\u5165\u53c2 id={}", (Object)id);
        return this.gameService.deleteGame(id);
    }

    @PutMapping(value={"/a/u/app/{id}"})
    public Long updateGame(@PathVariable(value="id") Long id, @RequestBody Game game) {
        log.info("service\u6a21\u5757 \u7f16\u8f91game \u5165\u53c2 id={},game={}", (Object)id, (Object)game);
        return this.gameService.updateGame(id, game);
    }

    @GetMapping(value={"/a/app/{id}"})
    public Game findById(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 \u5165\u53c2 select game id ={}", (Object)id);
        return this.gameService.findGameById(id);
    }

    @GetMapping(value={"/a/app/search/{type}"})
    public List<Game> listGameByQuery(@PathVariable(value="type") Integer type, @RequestParam(value="title", required=false) String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="startAt", required=false) Long startAt, @RequestParam(value="endAt", required=false) Long endAt) {
        log.info("service\u6a21\u5757 \u67e5\u8be2game\u5217\u8868\u5165\u53c2 type={},title={},status={},startAt={},endAt={}", new Object[]{type, title, status, startAt, endAt});
        List gameList = this.gameService.listGameByQuery(type, title, status, startAt, endAt);
        log.info("service\u6a21\u5757 \u67e5\u8be2evaluate\u5217\u8868\u6210\u529f size={}", (Object)gameList.size());
        return gameList;
    }

    @PutMapping(value={"/a/u/app/list"})
    public Long updateList(@RequestBody List<Game> gameList) {
        log.info("service \u6a21\u5757 game\u6279\u91cf\u66f4\u65b0 size={}", (Object)gameList.size());
        return this.gameService.updateList(gameList);
    }
}

