/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Evaluating;
import com.ptteng.iqiyi.admin.service.EvaluatingService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EvaluatingController {
    private static final Logger log = LoggerFactory.getLogger(EvaluatingController.class);
    @Autowired
    private EvaluatingService evaluatingService;

    @PostMapping(value={"/a/u/evaluate/{type}"})
    public Long saveEvaluating(@PathVariable(value="type") Integer type, @RequestBody Evaluating evaluating) {
        log.info("service\u6a21\u5757 \u65b0\u589eevaluating \u5165\u53c2 evaluating = {}", (Object)evaluating);
        Long id = this.evaluatingService.saveEvaluating(type, evaluating);
        log.info("service\u6a21\u5757 \u65b0\u589eevaluating \u6210\u529f id = {}", (Object)id);
        return id;
    }

    @DeleteMapping(value={"/a/u/evaluate/{id}"})
    public Long deleteEvaluating(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 \u5220\u9664evaluating\u5165\u53c2 id={}", (Object)id);
        return this.evaluatingService.deleteEvaluating(id);
    }

    @PutMapping(value={"/a/u/evaluate/{id}"})
    public Long updateEvaluating(@PathVariable(value="id") Long id, @RequestBody Evaluating evaluating) {
        log.info("service\u6a21\u5757 \u7f16\u8f91evaluating \u5165\u53c2 id={},evaluating={}", (Object)id, (Object)evaluating);
        return this.evaluatingService.updateEvaluating(id, evaluating);
    }

    @GetMapping(value={"/a/evaluate/{id}"})
    public Evaluating findEvaluatingById(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 \u5165\u53c2 select Evaluating id ={}", (Object)id);
        return this.evaluatingService.findEvaluatingById(id);
    }

    @GetMapping(value={"/a/u/evaluate/search/{type}"})
    public List<Evaluating> findEvaluatingList(@PathVariable(value="type") Integer type, @RequestParam(value="title", required=false) String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="startAt", required=false) Long startAt, @RequestParam(value="endAt", required=false) Long endAt) {
        log.info("service\u6a21\u5757 \u67e5\u8be2evaluate\u5217\u8868\u5165\u53c2 type={},title={},status={},startAt={},endAt={}", new Object[]{type, title, status, startAt, endAt});
        List evaluatingList = this.evaluatingService.findEvaluatingList(type, title, status, startAt, endAt);
        log.info("service\u6a21\u5757 \u67e5\u8be2evaluate\u5217\u8868\u6210\u529f size={}", (Object)evaluatingList.size());
        return evaluatingList;
    }

    @PutMapping(value={"/a/u/evaluate/list"})
    public Long updateList(@RequestBody List<Evaluating> evaluatingList) {
        log.info("service \u6a21\u5757 evaluate\u6279\u91cf\u66f4\u65b0 size={}", (Object)evaluatingList.size());
        return this.evaluatingService.updateList(evaluatingList);
    }
}

