/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.iqiyi.admin.controller;

import com.ptteng.iqiyi.admin.model.Banner;
import com.ptteng.iqiyi.admin.service.BannerService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BannerController {
    private static final Logger log = LoggerFactory.getLogger(BannerController.class);
    @Autowired
    private BannerService bannerService;

    @PostMapping(value={"/a/u/banner/{type}"})
    public Long createBanner(@RequestBody Banner banner, @PathVariable(value="type") Integer type) {
        Long bannerID = this.bannerService.saveBanner(type, banner);
        log.info("service\u6a21\u5757 \u65b0\u589ebanner id ={}", (Object)bannerID);
        return bannerID;
    }

    @DeleteMapping(value={"/a/u/banner/{id}"})
    public Long deleteBanner(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 deleteBanner=========" + id);
        return this.bannerService.deleteBanner(id);
    }

    @PutMapping(value={"/a/u/banner/{id}"})
    public Long updateBanner(@PathVariable(value="id") Long id, @RequestBody Banner banner) {
        log.info("service\u6a21\u5757 updateBanner======" + banner);
        Long result = this.bannerService.updateOne(id, banner);
        log.info("service\u6a21\u5757 update result======{}", (Object)result);
        return result;
    }

    @GetMapping(value={"/a/banner/{id}"})
    public Banner findOneBanner(@PathVariable(value="id") Long id) {
        log.info("service\u6a21\u5757 findOneBanner=========id={}", (Object)id);
        Banner banner = this.bannerService.findBannerById(id);
        log.info("====banner==========" + banner);
        return banner;
    }

    @GetMapping(value={"/a/banner/search/{type}"})
    public List<Banner> findAllBanner(@PathVariable(value="type") Integer type, @RequestParam(value="title", required=false) String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="startAt", required=false) Long startAt, @RequestParam(value="endAt", required=false) Long endAt) {
        log.info("service\u6a21\u5757 \u67e5\u8be2banner\u5217\u8868 type = {},title={},status={}", new Object[]{type, title, status});
        return this.bannerService.findAllBanner(type, title, status, startAt, endAt);
    }

    @PutMapping(value={"/a/u/banner/status/{id}"})
    public Long updateStatus(@RequestBody Banner banner, @PathVariable(value="id") Long bannerID) {
        this.bannerService.updateOne(bannerID, banner);
        log.info("service\u6a21\u5757 \u4fee\u6539banner\u4e0a\u4e0b\u67b6\u72b6\u6001 banner={}", (Object)banner);
        return banner.getId();
    }

    @PutMapping(value={"/a/u/banner/list"})
    Long updateList(@RequestBody List<Banner> bannerList) {
        log.info("service\u6a21\u5757 banner\u6279\u91cf\u66f4\u65b0 size={}", (Object)bannerList.size());
        return this.bannerService.updateList(bannerList);
    }
}

