package com.ptteng.invoice.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

import com.ptteng.invoice.common.model.Sms;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SmsService extends BaseDaoService {


    public String ErrorCode_SMS_InvalidType = "invalideType";

    public String ErrorCode_SMS_smsMoreThan5 = "smsMoreThan5";

    public String ErrorCode_sendError = "sendError";




    public Long insert(Sms sms) throws ServiceException, ServiceDaoException;


    public List<Sms> insertList(List<Sms> smsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Sms sms) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Sms> smsList) throws ServiceException, ServiceDaoException;


    public Sms getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Sms> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getSmsIdByMobileAndType(String mobile, String type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSmsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSmsIds() throws ServiceException, ServiceDaoException;


    /**
     * send message
     *
     * @param phone
     * @param type
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @throws Exception
     */
    public String sendMsg(String phone, String type) throws ServiceException, ServiceDaoException;


    /**
     * send voice
     *
     * @param phone
     * @param type
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @throws Exception
     */
    public String sendVoice(String phone, String type) throws ServiceException, ServiceDaoException;


}

