/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.ServiceStation;
import com.ptteng.goldwind.common.service.ServiceStationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceStationServiceImpl
extends BaseDaoServiceImpl
implements ServiceStationService {
    private static final Log log = LogFactory.getLog(ServiceStationServiceImpl.class);

    public Long insert(ServiceStation serviceStation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + serviceStation));
        if (serviceStation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        serviceStation.setCreateAt(Long.valueOf(currentTimeMillis));
        serviceStation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)serviceStation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + serviceStation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ServiceStation> insertList(List<ServiceStation> serviceStationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (serviceStationList == null ? "null" : Integer.valueOf(serviceStationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(serviceStationList)) {
            return new ArrayList<ServiceStation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ServiceStation serviceStation : serviceStationList) {
            serviceStation.setCreateAt(Long.valueOf(currentTimeMillis));
            serviceStation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(serviceStationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + serviceStationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ServiceStation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ServiceStation serviceStation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (serviceStation == null ? "null" : serviceStation.getId())));
        boolean result = false;
        if (serviceStation == null) {
            return true;
        }
        serviceStation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)serviceStation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + serviceStation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + serviceStation));
        }
        return result;
    }

    public boolean updateList(List<ServiceStation> serviceStationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (serviceStationList == null ? "null" : Integer.valueOf(serviceStationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(serviceStationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ServiceStation serviceStation : serviceStationList) {
            serviceStation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(serviceStationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + serviceStationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + serviceStationList.size()));
        return result;
    }

    public ServiceStation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ServiceStation serviceStation = null;
        if (id == null) {
            return serviceStation;
        }
        try {
            serviceStation = (ServiceStation)this.dao.get(ServiceStation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return serviceStation;
    }

    public List<ServiceStation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List serviceStation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ServiceStation>();
        }
        try {
            serviceStation = this.dao.getList(ServiceStation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (serviceStation == null ? "null" : Integer.valueOf(serviceStation.size()))));
        return serviceStation;
    }

    public List<Long> getServiceStationIdsByTelephone(String telephone, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by telephone,start,limit  : " + telephone + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServiceStationIdsByTelephone", new Object[]{telephone}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by telephone,start,limit)  : " + telephone + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getServiceStationIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServiceStationIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getServiceStationIdsByStatusAndTelephone(Integer status, String telephone, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,telephone,start,limit  : " + status + " , " + telephone + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServiceStationIdsByStatusAndTelephone", new Object[]{status, telephone}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,telephone,start,limit)  : " + status + " , " + telephone + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countServiceStationIdsByTelephone(String telephone) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by telephone  : " + telephone));
        }
        Integer count = null;
        try {
            count = this.dao.count("getServiceStationIdsByTelephone", new Object[]{telephone});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by telephone)  : " + telephone));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countServiceStationIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getServiceStationIdsByStatus", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countServiceStationIdsByStatusAndTelephone(Integer status, String telephone) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,telephone  : " + status + " , " + telephone));
        }
        Integer count = null;
        try {
            count = this.dao.count("getServiceStationIdsByStatusAndTelephone", new Object[]{status, telephone});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,telephone)  : " + status + " , " + telephone));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getServiceStationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getServiceStationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countServiceStationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getServiceStationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getServiceStationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

