/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.ProductDir;
import com.ptteng.goldwind.common.service.ProductDirService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProductDirServiceImpl
extends BaseDaoServiceImpl
implements ProductDirService {
    private static final Log log = LogFactory.getLog(ProductDirServiceImpl.class);

    public Long insert(ProductDir productDir) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + productDir));
        if (productDir == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        productDir.setCreateAt(Long.valueOf(currentTimeMillis));
        productDir.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)productDir);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + productDir));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ProductDir> insertList(List<ProductDir> productDirList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (productDirList == null ? "null" : Integer.valueOf(productDirList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(productDirList)) {
            return new ArrayList<ProductDir>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProductDir productDir : productDirList) {
            productDir.setCreateAt(Long.valueOf(currentTimeMillis));
            productDir.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(productDirList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + productDirList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ProductDir.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ProductDir productDir) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (productDir == null ? "null" : productDir.getId())));
        boolean result = false;
        if (productDir == null) {
            return true;
        }
        productDir.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)productDir);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + productDir));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + productDir));
        }
        return result;
    }

    public boolean updateList(List<ProductDir> productDirList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (productDirList == null ? "null" : Integer.valueOf(productDirList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(productDirList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProductDir productDir : productDirList) {
            productDir.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(productDirList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + productDirList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + productDirList.size()));
        return result;
    }

    public ProductDir getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ProductDir productDir = null;
        if (id == null) {
            return productDir;
        }
        try {
            productDir = (ProductDir)this.dao.get(ProductDir.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return productDir;
    }

    public List<ProductDir> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List productDir = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProductDir>();
        }
        try {
            productDir = this.dao.getList(ProductDir.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (productDir == null ? "null" : Integer.valueOf(productDir.size()))));
        return productDir;
    }

    public List<Long> getProductDirIdsByDirIdAndStatus(Long dirId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by dirId,status,start,limit  : " + dirId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductDirIdsByDirIdAndStatus", new Object[]{dirId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by dirId,status,start,limit)  : " + dirId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProductDirIdsByDirId(Long dirId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by dirId,start,limit  : " + dirId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductDirIdsByDirId", new Object[]{dirId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by dirId,start,limit)  : " + dirId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductDirIdsByDirIdAndStatus(Long dirId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by dirId,status  : " + dirId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductDirIdsByDirIdAndStatus", new Object[]{dirId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by dirId,status)  : " + dirId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProductDirIdsByDirId(Long dirId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by dirId  : " + dirId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductDirIdsByDirId", new Object[]{dirId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by dirId)  : " + dirId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProductDirIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductDirIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductDirIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProductDirIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProductDirIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

