/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.OrderProduct;
import com.ptteng.goldwind.common.service.OrderProductService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderProductServiceImpl
extends BaseDaoServiceImpl
implements OrderProductService {
    private static final Log log = LogFactory.getLog(OrderProductServiceImpl.class);

    public Long insert(OrderProduct orderProduct) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + orderProduct));
        if (orderProduct == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        orderProduct.setCreateAt(Long.valueOf(currentTimeMillis));
        orderProduct.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)orderProduct);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + orderProduct));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<OrderProduct> insertList(List<OrderProduct> orderProductList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (orderProductList == null ? "null" : Integer.valueOf(orderProductList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(orderProductList)) {
            return new ArrayList<OrderProduct>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (OrderProduct orderProduct : orderProductList) {
            orderProduct.setCreateAt(Long.valueOf(currentTimeMillis));
            orderProduct.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(orderProductList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + orderProductList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(OrderProduct.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(OrderProduct orderProduct) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (orderProduct == null ? "null" : orderProduct.getId())));
        boolean result = false;
        if (orderProduct == null) {
            return true;
        }
        orderProduct.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)orderProduct);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + orderProduct));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + orderProduct));
        }
        return result;
    }

    public boolean updateList(List<OrderProduct> orderProductList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (orderProductList == null ? "null" : Integer.valueOf(orderProductList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(orderProductList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (OrderProduct orderProduct : orderProductList) {
            orderProduct.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(orderProductList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + orderProductList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + orderProductList.size()));
        return result;
    }

    public OrderProduct getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        OrderProduct orderProduct = null;
        if (id == null) {
            return orderProduct;
        }
        try {
            orderProduct = (OrderProduct)this.dao.get(OrderProduct.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return orderProduct;
    }

    public List<OrderProduct> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List orderProduct = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OrderProduct>();
        }
        try {
            orderProduct = this.dao.getList(OrderProduct.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (orderProduct == null ? "null" : Integer.valueOf(orderProduct.size()))));
        return orderProduct;
    }

    public List<Long> getOrderProductIdsByOrderId(Long orderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by orderId,start,limit  : " + orderId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderProductIdsByOrderId", new Object[]{orderId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by orderId,start,limit)  : " + orderId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getOrderProductIdsByOrderIdAndStatus(Long orderId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by orderId,status,start,limit  : " + orderId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderProductIdsByOrderIdAndStatus", new Object[]{orderId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by orderId,status,start,limit)  : " + orderId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderProductIdsByOrderId(Long orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by orderId  : " + orderId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrderProductIdsByOrderId", new Object[]{orderId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by orderId)  : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countOrderProductIdsByOrderIdAndStatus(Long orderId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by orderId,status  : " + orderId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrderProductIdsByOrderIdAndStatus", new Object[]{orderId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by orderId,status)  : " + orderId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getOrderProductIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderProductIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderProductIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrderProductIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrderProductIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

