/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Favorite;
import com.ptteng.goldwind.common.service.FavoriteService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FavoriteServiceImpl
extends BaseDaoServiceImpl
implements FavoriteService {
    private static final Log log = LogFactory.getLog(FavoriteServiceImpl.class);

    public Long insert(Favorite favorite) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + favorite));
        if (favorite == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        favorite.setCreateAt(Long.valueOf(currentTimeMillis));
        favorite.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)favorite);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + favorite));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Favorite> insertList(List<Favorite> favoriteList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (favoriteList == null ? "null" : Integer.valueOf(favoriteList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(favoriteList)) {
            return new ArrayList<Favorite>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Favorite favorite : favoriteList) {
            favorite.setCreateAt(Long.valueOf(currentTimeMillis));
            favorite.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(favoriteList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + favoriteList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Favorite.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Favorite favorite) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (favorite == null ? "null" : favorite.getId())));
        boolean result = false;
        if (favorite == null) {
            return true;
        }
        favorite.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)favorite);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + favorite));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + favorite));
        }
        return result;
    }

    public boolean updateList(List<Favorite> favoriteList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (favoriteList == null ? "null" : Integer.valueOf(favoriteList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(favoriteList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Favorite favorite : favoriteList) {
            favorite.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(favoriteList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + favoriteList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + favoriteList.size()));
        return result;
    }

    public Favorite getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Favorite favorite = null;
        if (id == null) {
            return favorite;
        }
        try {
            favorite = (Favorite)this.dao.get(Favorite.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return favorite;
    }

    public List<Favorite> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List favorite = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Favorite>();
        }
        try {
            favorite = this.dao.getList(Favorite.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (favorite == null ? "null" : Integer.valueOf(favorite.size()))));
        return favorite;
    }

    public List<Long> getFavoriteIdsByUId(Long uId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uId,start,limit  : " + uId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFavoriteIdsByUId", new Object[]{uId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uId,start,limit)  : " + uId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFavoriteIdsByUId(Long uId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uId  : " + uId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getFavoriteIdsByUId", new Object[]{uId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uId)  : " + uId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getFavoriteIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFavoriteIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFavoriteIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getFavoriteIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getFavoriteIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

