/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Commodity;
import com.ptteng.goldwind.common.service.CommodityService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommodityServiceImpl
extends BaseDaoServiceImpl
implements CommodityService {
    private static final Log log = LogFactory.getLog(CommodityServiceImpl.class);

    public Long insert(Commodity commodity) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + commodity));
        if (commodity == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        commodity.setCreateAt(Long.valueOf(currentTimeMillis));
        commodity.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)commodity);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + commodity));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Commodity> insertList(List<Commodity> commodityList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (commodityList == null ? "null" : Integer.valueOf(commodityList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(commodityList)) {
            return new ArrayList<Commodity>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Commodity commodity : commodityList) {
            commodity.setCreateAt(Long.valueOf(currentTimeMillis));
            commodity.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(commodityList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + commodityList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Commodity.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Commodity commodity) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (commodity == null ? "null" : commodity.getId())));
        boolean result = false;
        if (commodity == null) {
            return true;
        }
        commodity.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)commodity);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + commodity));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + commodity));
        }
        return result;
    }

    public boolean updateList(List<Commodity> commodityList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (commodityList == null ? "null" : Integer.valueOf(commodityList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(commodityList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Commodity commodity : commodityList) {
            commodity.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(commodityList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + commodityList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + commodityList.size()));
        return result;
    }

    public Commodity getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Commodity commodity = null;
        if (id == null) {
            return commodity;
        }
        try {
            commodity = (Commodity)this.dao.get(Commodity.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return commodity;
    }

    public List<Commodity> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List commodity = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Commodity>();
        }
        try {
            commodity = this.dao.getList(Commodity.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (commodity == null ? "null" : Integer.valueOf(commodity.size()))));
        return commodity;
    }

    public List<Long> getCommodityIdsByAccount(String account, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by account,start,limit  : " + account + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommodityIdsByAccount", new Object[]{account}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + account + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCommodityIdsByAccount(String account) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by account  : " + account));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCommodityIdsByAccount", new Object[]{account});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by account)  : " + account));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCommodityIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommodityIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCommodityIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCommodityIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCommodityIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

