/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.bean.yl;

import com.gemantic.common.util.MyTimeUtil;
import com.qding.common.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RequestBean {
    private static final Log log = LogFactory.getLog(RequestBean.class);
    private String sendSeqId;
    private String application;
    private String merchantName;
    private String merchantId;
    private String merchantOrderId;
    private String merchantOrderTime;
    private String merchantOrderAmt;
    private String merchantOrderCurrency;
    private String merchantOrderDesc;
    private String transTimeout;
    private String transType = "01";
    private String gwType;
    private String frontUrl;
    private String backUrl;
    private String merchantUserId;
    private String mobileNum;
    private String userName;
    private String idType;
    private String idNum;
    private String cardNum;
    private String msgExt;
    private String misc;

    public Document toDocument() {
        Calendar c = Calendar.getInstance();
        Document doc = new Document();
        Element root = new Element("upbp");
        root.setAttribute("application", this.application);
        root.setAttribute("version", "1.0.0");
        root.setAttribute("sendTime", RequestBean.formatDate(c.getTime()));
        this.sendSeqId = MyTimeUtil.getTimeInyyyyMMdd() + DataUtils.getRandomIntString((int)4);
        root.setAttribute("sendSeqId", this.sendSeqId);
        doc.setRootElement(root);
        this.createElement(root, "merchantId", this.merchantId);
        this.createElement(root, "merchantOrderId", this.merchantOrderId);
        this.createElement(root, "merchantOrderTime", this.merchantOrderTime);
        this.createElement(root, "merchantOrderAmt", this.merchantOrderAmt);
        this.createElement(root, "merchantOrderCurrency", this.merchantOrderCurrency);
        this.createElement(root, "merchantOrderDesc", this.merchantOrderDesc);
        int timeout = Integer.parseInt(this.transTimeout);
        c.add(12, timeout);
        this.createElement(root, "transTimeout", RequestBean.formatDate(c.getTime()));
        this.createElement(root, "transType", this.transType);
        this.createElement(root, "gwType", this.gwType);
        this.createElement(root, "frontUrl", this.frontUrl);
        this.createElement(root, "backUrl", this.backUrl);
        this.createElement(root, "merchantUserId", this.merchantUserId);
        this.createElement(root, "mobileNum", this.mobileNum);
        this.createElement(root, "userName", this.userName);
        this.createElement(root, "idType", this.idType);
        this.createElement(root, "idNum", this.idNum);
        this.createElement(root, "cardNum", this.cardNum);
        this.createElement(root, "msgExt", this.msgExt);
        this.createElement(root, "misc", this.misc);
        return doc;
    }

    private Element createElement(Element parent, String name, String value) {
        Element elem = new Element(name);
        elem.setText(value + "#@#");
        parent.getChildren().add(elem);
        return elem;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        return formatter.format(date);
    }

    public String doc2String(Document doc) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            XMLOutputter xmlout = new XMLOutputter(format);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            xmlout.output(doc, (OutputStream)bo);
            return bo.toString().replace("#@#", "").replace("null", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public String getMerchantOrderTime() {
        return this.merchantOrderTime;
    }

    public void setMerchantOrderTime(String merchantOrderTime) {
        this.merchantOrderTime = merchantOrderTime;
    }

    public String getMerchantOrderAmt() {
        return this.merchantOrderAmt;
    }

    public void setMerchantOrderAmt(String merchantOrderAmt) {
        this.merchantOrderAmt = merchantOrderAmt;
    }

    public String getMerchantOrderCurrency() {
        return this.merchantOrderCurrency;
    }

    public void setMerchantOrderCurrency(String merchantOrderCurrency) {
        this.merchantOrderCurrency = merchantOrderCurrency;
    }

    public String getMerchantOrderDesc() {
        return this.merchantOrderDesc;
    }

    public void setMerchantOrderDesc(String merchantOrderDesc) {
        this.merchantOrderDesc = merchantOrderDesc;
    }

    public String getTransTimeout() {
        return this.transTimeout;
    }

    public void setTransTimeout(String transTimeout) {
        this.transTimeout = transTimeout;
    }

    public String getTransType() {
        return this.transType;
    }

    public void setTransType(String transType) {
        this.transType = transType;
    }

    public String getGwType() {
        return this.gwType;
    }

    public void setGwType(String gwType) {
        this.gwType = gwType;
    }

    public String getFrontUrl() {
        return this.frontUrl;
    }

    public void setFrontUrl(String frontUrl) {
        this.frontUrl = frontUrl;
    }

    public String getBackUrl() {
        return this.backUrl;
    }

    public void setBackUrl(String backUrl) {
        this.backUrl = backUrl;
    }

    public String getMerchantUserId() {
        return this.merchantUserId;
    }

    public void setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
    }

    public String getMobileNum() {
        return this.mobileNum;
    }

    public void setMobileNum(String mobileNum) {
        this.mobileNum = mobileNum;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdNum() {
        return this.idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }

    public String getCardNum() {
        return this.cardNum;
    }

    public void setCardNum(String cardNum) {
        this.cardNum = cardNum;
    }

    public String getMsgExt() {
        return this.msgExt;
    }

    public void setMsgExt(String msgExt) {
        this.msgExt = msgExt;
    }

    public String getMisc() {
        return this.misc;
    }

    public void setMisc(String misc) {
        this.misc = misc;
    }

    public void setApplication(String application) {
        this.application = application;
    }
}

