/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.gene.business.model.Paraphrase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ParaphraseUtil {
    public static Map<String, Object> getParaphraseListParamIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("paraphrase");
        String condition = "";
        if (ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                condition = i != 0 ? condition + " or item_locus_relation_id = " + ids.get(i) : condition + ids.get(i);
            }
            params.put("item_locus_relation_id ", condition);
        } else {
            params.put("item_locus_relation_id ", -1);
        }
        params.put("@query", " id");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getParaphraseListParam(Long classifyId, String locusName, String itemName, String geneName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("locus");
        tables.add("item");
        tables.add("paraphrase");
        params.put("item.id", "paraphrase.item_id");
        params.put("locus.name", "paraphrase.locus_name");
        if (classifyId != null) {
            params.put(" item.classify_id ", classifyId);
        }
        if (locusName != null) {
            params.put(" locus.name & like", " '%" + locusName + "%'");
        }
        if (itemName != null) {
            params.put(" item.name & like", " '%" + locusName + "%'");
        }
        if (geneName != null) {
            params.put(" locus.gene & like ", " '%" + geneName + "%'");
        }
        params.put("@order", "  paraphrase.create_at desc ");
        params.put("@query", " paraphrase.id");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<Long, List<Paraphrase>> covertPHList2Map(List<Paraphrase> paraphraseList) {
        HashMap<Long, List<Paraphrase>> rid_phList = new HashMap<Long, List<Paraphrase>>();
        for (Paraphrase paraphrase : paraphraseList) {
            List<Paraphrase> phLists = null;
            phLists = rid_phList.containsKey(paraphrase.getItemLocusRelationId()) ? (List)rid_phList.get(paraphrase.getItemLocusRelationId()) : new ArrayList<Paraphrase>();
            phLists.add(paraphrase);
            rid_phList.put(paraphrase.getItemLocusRelationId(), phLists);
        }
        return rid_phList;
    }
}

