package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.OrdersInfo;
import com.ptteng.fans.common.service.OrdersInfoService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class OrdersInfoServiceImpl extends BaseDaoServiceImpl implements OrdersInfoService {

 

	private static final Log log = LogFactory.getLog(OrdersInfoServiceImpl.class);



		   
		@Override
		public Long insert(OrdersInfo ordersInfo)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + ordersInfo);

		if (ordersInfo == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		ordersInfo.setCreateAt(currentTimeMillis);
		ordersInfo.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(ordersInfo);
		} catch (DaoException e) {
			log.error(" insert wrong : " + ordersInfo);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<OrdersInfo> insertList(List<OrdersInfo> ordersInfoList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (ordersInfoList == null ? "null" : ordersInfoList.size()));
      
		List<OrdersInfo> resultList = null;

		if (CollectionUtils.isEmpty(ordersInfoList)) {
			return new ArrayList<OrdersInfo>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (OrdersInfo ordersInfo : ordersInfoList) {
			ordersInfo.setCreateAt(currentTimeMillis);
			ordersInfo.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<OrdersInfo>) dao.batchSave(ordersInfoList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + ordersInfoList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(OrdersInfo.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(OrdersInfo ordersInfo)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (ordersInfo == null ? "null" : ordersInfo.getId()));

		boolean result = false;

		if (ordersInfo == null) {
			return true;
		}

		ordersInfo.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(ordersInfo);
		} catch (DaoException e) {
			log.error(" update wrong : " + ordersInfo);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + ordersInfo);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<OrdersInfo> ordersInfoList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (ordersInfoList == null ? "null" : ordersInfoList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(ordersInfoList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (OrdersInfo ordersInfo : ordersInfoList) {
			ordersInfo.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(ordersInfoList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + ordersInfoList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + ordersInfoList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public OrdersInfo getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		OrdersInfo ordersInfo = null;

		if (id == null) {
			return ordersInfo;
		}

		try {
			ordersInfo = (OrdersInfo) dao.get(OrdersInfo.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return ordersInfo;		
		}	
		  
    	   
		@Override
		public List<OrdersInfo> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<OrdersInfo> ordersInfo = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<OrdersInfo>();
		}

		try {
			ordersInfo = (List<OrdersInfo>) dao.getList(OrdersInfo.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (ordersInfo == null ? "null" : ordersInfo.size()));
    
		return ordersInfo;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersInfoIdByOrdersId(Long ordersId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by ordersId  : " + ordersId );
	  }
         List<Long> ids = new ArrayList<>();
	
      // TODO 参数检查!
      
	try {



        ids = (List<Long>) dao.getIdList("getOrdersInfoIdByOrdersId", new Object[] {ordersId },start,limit, false);
   } catch (DaoException e) {
			log.error(" get id wrong by ordersId  : " + ordersId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + ids);
   }
		return ids;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrdersInfoIdsByBizIdAndBizType(Long bizId,Integer bizType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by bizId,bizType,start,limit  : " + bizId+" , "+bizType+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getOrdersInfoIdsByBizIdAndBizType", new Object[] { bizId,bizType},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by bizId,bizType,start,limit)  : " + bizId+" , "+bizType+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public Long getBizIdByOrdersId(Long ordersId) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get biz_id by ordersId : " + ordersId );
		}
		Long bizId = null;

		// TODO 参数检查!

		try {
			bizId = (Long) dao.getMapping("getBizIdByOrdersId", new Object[]{ordersId});


		} catch (DaoException e) {
			log.error(" get biz_id  wrong by ordersId  : " + ordersId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (bizId == null ? "null" : bizId));
		}
		return bizId;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrdersInfoIdsByBizIdAndBizType(Long bizId,Integer bizType)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by bizId,bizType  : " + bizId+" , "+bizType );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getOrdersInfoIdsByBizIdAndBizType", new Object[] { bizId,bizType});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by bizId,bizType)  : " + bizId+" , "+bizType );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getOrdersInfoIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getOrdersInfoIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countOrdersInfoIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getOrdersInfoIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getOrdersInfoIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

