package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.fans.common.model.Feedback;
import com.ptteng.fans.common.service.FeedbackService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class FeedbackServiceImpl extends BaseDaoServiceImpl implements FeedbackService {


    private static final Log log = LogFactory.getLog(FeedbackServiceImpl.class);


    @Override
    public Long insert(Feedback feedback) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + feedback);

        if (feedback == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        feedback.setCreateAt(currentTimeMillis);
        feedback.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(feedback);
        } catch (DaoException e) {
            log.error(" insert wrong : " + feedback);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Feedback> insertList(List<Feedback> feedbackList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (feedbackList == null ? "null" : feedbackList.size()));

        List<Feedback> resultList = null;

        if (CollectionUtils.isEmpty(feedbackList)) {
            return new ArrayList<Feedback>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Feedback feedback : feedbackList) {
            feedback.setCreateAt(currentTimeMillis);
            feedback.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Feedback>) dao.batchSave(feedbackList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + feedbackList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Feedback.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Feedback feedback) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (feedback == null ? "null" : feedback.getId()));

        boolean result = false;

        if (feedback == null) {
            return true;
        }

        feedback.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(feedback);
        } catch (DaoException e) {
            log.error(" update wrong : " + feedback);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + feedback);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Feedback> feedbackList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (feedbackList == null ? "null" : feedbackList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(feedbackList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Feedback feedback : feedbackList) {
            feedback.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(feedbackList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + feedbackList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + feedbackList.size());

        return result;
    }


    @Override
    public Feedback getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Feedback feedback = null;

        if (id == null) {
            return feedback;
        }

        try {
            feedback = (Feedback) dao.get(Feedback.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return feedback;
    }


    @Override
    public List<Feedback> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Feedback> feedback = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Feedback>();
        }

        try {
            feedback = (List<Feedback>) dao.getList(Feedback.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (feedback == null ? "null" : feedback.size()));

        return feedback;
    }


    @Override
    public List<Long> getFeedbackIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getFeedbackIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countFeedbackIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getFeedbackIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getFeedbackIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

