package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.ClassifyContentsRelation;
import com.ptteng.fans.common.service.ClassifyContentsRelationService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class ClassifyContentsRelationServiceImpl extends BaseDaoServiceImpl implements
    ClassifyContentsRelationService {

 

	private static final Log log = LogFactory.getLog(ClassifyContentsRelationServiceImpl.class);



		   
		@Override
		public Long insert(ClassifyContentsRelation classifyContentsRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + classifyContentsRelation);

		if (classifyContentsRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		classifyContentsRelation.setCreateAt(currentTimeMillis);
		classifyContentsRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(classifyContentsRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + classifyContentsRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ClassifyContentsRelation> insertList(List<ClassifyContentsRelation> classifyContentsRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (classifyContentsRelationList == null ? "null" : classifyContentsRelationList.size()));
      
		List<ClassifyContentsRelation> resultList = null;

		if (CollectionUtils.isEmpty(classifyContentsRelationList)) {
			return new ArrayList<ClassifyContentsRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ClassifyContentsRelation classifyContentsRelation : classifyContentsRelationList) {
			classifyContentsRelation.setCreateAt(currentTimeMillis);
			classifyContentsRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ClassifyContentsRelation>) dao.batchSave(classifyContentsRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + classifyContentsRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ClassifyContentsRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ClassifyContentsRelation classifyContentsRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (classifyContentsRelation == null ? "null" : classifyContentsRelation.getId()));

		boolean result = false;

		if (classifyContentsRelation == null) {
			return true;
		}

		classifyContentsRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(classifyContentsRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + classifyContentsRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + classifyContentsRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ClassifyContentsRelation> classifyContentsRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (classifyContentsRelationList == null ? "null" : classifyContentsRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(classifyContentsRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ClassifyContentsRelation classifyContentsRelation : classifyContentsRelationList) {
			classifyContentsRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(classifyContentsRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + classifyContentsRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + classifyContentsRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ClassifyContentsRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ClassifyContentsRelation classifyContentsRelation = null;

		if (id == null) {
			return classifyContentsRelation;
		}

		try {
			classifyContentsRelation = (ClassifyContentsRelation) dao.get(ClassifyContentsRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return classifyContentsRelation;		
		}	
		  
    	   
		@Override
		public List<ClassifyContentsRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ClassifyContentsRelation> classifyContentsRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ClassifyContentsRelation>();
		}

		try {
			classifyContentsRelation = (List<ClassifyContentsRelation>) dao.getList(
          ClassifyContentsRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (classifyContentsRelation == null ? "null" : classifyContentsRelation.size()));
    
		return classifyContentsRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClassifyContentsRelationIdsByClassifyId(Long classifyId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by classifyId,start,limit  : " + classifyId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getClassifyContentsRelationIdsByClassifyId", new Object[] { classifyId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by classifyId,start,limit)  : " + classifyId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClassifyContentsRelationIdsByContentsId(Long contentsId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by contentsId,start,limit  : " + contentsId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getClassifyContentsRelationIdsByContentsId", new Object[] { contentsId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by contentsId,start,limit)  : " + contentsId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClassifyContentsRelationIdsByClassifyId(Long classifyId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by classifyId  : " + classifyId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getClassifyContentsRelationIdsByClassifyId", new Object[] { classifyId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by classifyId)  : " + classifyId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClassifyContentsRelationIdsByContentsId(Long contentsId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by contentsId  : " + contentsId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getClassifyContentsRelationIdsByContentsId", new Object[] { contentsId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by contentsId)  : " + contentsId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getClassifyContentsRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getClassifyContentsRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countClassifyContentsRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getClassifyContentsRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getClassifyContentsRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

