package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.BaseClassifyResource;
import com.ptteng.fans.common.service.BaseClassifyResourceService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class BaseClassifyResourceServiceImpl extends BaseDaoServiceImpl implements BaseClassifyResourceService {

 

	private static final Log log = LogFactory.getLog(BaseClassifyResourceServiceImpl.class);



		   
		@Override
		public Long insert(BaseClassifyResource baseClassifyResource)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + baseClassifyResource);

		if (baseClassifyResource == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		baseClassifyResource.setCreateAt(currentTimeMillis);
		baseClassifyResource.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(baseClassifyResource);
		} catch (DaoException e) {
			log.error(" insert wrong : " + baseClassifyResource);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<BaseClassifyResource> insertList(List<BaseClassifyResource> baseClassifyResourceList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (baseClassifyResourceList == null ? "null" : baseClassifyResourceList.size()));
      
		List<BaseClassifyResource> resultList = null;

		if (CollectionUtils.isEmpty(baseClassifyResourceList)) {
			return new ArrayList<BaseClassifyResource>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BaseClassifyResource baseClassifyResource : baseClassifyResourceList) {
			baseClassifyResource.setCreateAt(currentTimeMillis);
			baseClassifyResource.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<BaseClassifyResource>) dao.batchSave(baseClassifyResourceList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + baseClassifyResourceList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(BaseClassifyResource.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(BaseClassifyResource baseClassifyResource)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (baseClassifyResource == null ? "null" : baseClassifyResource.getId()));

		boolean result = false;

		if (baseClassifyResource == null) {
			return true;
		}

		baseClassifyResource.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(baseClassifyResource);
		} catch (DaoException e) {
			log.error(" update wrong : " + baseClassifyResource);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + baseClassifyResource);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<BaseClassifyResource> baseClassifyResourceList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (baseClassifyResourceList == null ? "null" : baseClassifyResourceList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(baseClassifyResourceList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BaseClassifyResource baseClassifyResource : baseClassifyResourceList) {
			baseClassifyResource.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(baseClassifyResourceList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + baseClassifyResourceList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + baseClassifyResourceList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public BaseClassifyResource getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		BaseClassifyResource baseClassifyResource = null;

		if (id == null) {
			return baseClassifyResource;
		}

		try {
			baseClassifyResource = (BaseClassifyResource) dao.get(BaseClassifyResource.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return baseClassifyResource;		
		}	
		  
    	   
		@Override
		public List<BaseClassifyResource> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<BaseClassifyResource> baseClassifyResource = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<BaseClassifyResource>();
		}

		try {
			baseClassifyResource = (List<BaseClassifyResource>) dao.getList(BaseClassifyResource.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (baseClassifyResource == null ? "null" : baseClassifyResource.size()));
    
		return baseClassifyResource;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBaseClassifyResourceIdsByBizIdAndBizType(Long bizId,Integer bizType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by bizId,bizType,start,limit  : " + bizId+" , "+bizType+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getBaseClassifyResourceIdsByBizIdAndBizType", new Object[] { bizId,bizType},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by bizId,bizType,start,limit)  : " + bizId+" , "+bizType+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBaseClassifyResourceIdsByBaseClassifyId(Long baseClassifyId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by baseClassifyId,start,limit  : " + baseClassifyId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getBaseClassifyResourceIdsByBaseClassifyId", new Object[] { baseClassifyId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by baseClassifyId,start,limit)  : " + baseClassifyId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

    @Override
    public List<Long> getBaseClassifyResourceIdsByBaseClassifyIdAndBizType(Long baseClassifyId, Integer bizType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if(log.isInfoEnabled()){
            log.info(" get ids by baseClassifyId,start,limit  : " + baseClassifyId+" , "+start+" , "+limit );
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getBaseClassifyResourceIdsByBaseClassifyIdAndBizType", new Object[] { baseClassifyId,bizType},start,limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by baseClassifyId,start,limit)  : " + baseClassifyId+" , "+start+" , "+limit );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;



    }


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBaseClassifyResourceIdsByBizIdAndBizType(Long bizId,Integer bizType)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by bizId,bizType  : " + bizId+" , "+bizType );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getBaseClassifyResourceIdsByBizIdAndBizType", new Object[] { bizId,bizType});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by bizId,bizType)  : " + bizId+" , "+bizType );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBaseClassifyResourceIdsByBaseClassifyId(Long baseClassifyId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by baseClassifyId  : " + baseClassifyId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getBaseClassifyResourceIdsByBaseClassifyId", new Object[] { baseClassifyId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by baseClassifyId)  : " + baseClassifyId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}

    @Override
    public Integer countBaseClassifyResourceIdsByBaseClassifyIdAndBizType(Long baseClassifyId, Integer bizType) throws ServiceException, ServiceDaoException {
        if(log.isInfoEnabled()){
            log.info(" count ids by baseClassifyId  : " + baseClassifyId );
        }
        Integer count=null;



        try {

            count = dao.count("getBaseClassifyResourceIdsByBaseClassifyIdAndBizType", new Object[] { baseClassifyId,bizType});


        } catch (DaoException e) {
            log.error(" count ids  wrong by baseClassifyId)  : " + baseClassifyId );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
	public List<Long> getBaseClassifyResourceIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getBaseClassifyResourceIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countBaseClassifyResourceIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBaseClassifyResourceIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBaseClassifyResourceIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

