package com.ptteng.fans.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.fans.common.model.BaseClassify;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface BaseClassifyService extends BaseDaoService {


  public Long insert(BaseClassify baseClassify,String lang) throws Exception;


  public List<BaseClassify> insertList(List<BaseClassify> baseClassifyList,String lang)
      throws Exception;


  public boolean delete(Long id,String lang) throws Exception;


  public boolean update(BaseClassify baseClassify,String lang) throws Exception;


  public boolean updateList(List<BaseClassify> baseClassifyList,String lang)
      throws Exception;


  public BaseClassify getObjectById(Long id,String lang) throws Exception;


  public List<BaseClassify> getObjectsByIds(List<Long> ids,String lang)
      throws Exception;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countBaseClassifyIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId)
      throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countBaseClassifyIdsByType(Integer type)
      throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countBaseClassifyIdsByMerchantId(Long merchantId)
      throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getBaseClassifyIdsByTypeAndMerchantIdOrderBySort(Integer type,
      Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getBaseClassifyIdsByType(Integer type, Integer start, Integer limit)
      throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getBaseClassifyIdsByMerchantId(Long merchantId, Integer start, Integer limit)
      throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getBaseClassifyIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException;

  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countBaseClassifyIds() throws ServiceException, ServiceDaoException;


}

