package com.ptteng.fans.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "orders_info")
public class OrdersInfo implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3207773526180783104L;
    //商品sku
    public static final int BIZ_TYPE_SKU = 1;
    public static final int BIZ_TYPE_SERVICE = 2;
    public static final int BIZ_TYPE_DEPOSIT = 3;
    // 盲盒系列
    public static final int BIZ_TYPE_SERIES = 4;
    public static final int BIZ_TYPE_SHIPPING = 5;

    public static final int SUCCESS = 1;
    public static final int FAIL = 0;
    public static final int WAIT = -1;
    public static final int WARN = 2;

    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 订单id
     */
    private Long ordersId;


    /**
     * 数据id
     */
    private Long bizId;

    private String bizTitle;

    /**
     * 数据类型
     */
    private Integer bizType;


    /**
     * json
     */
    private String content;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 数量
     */
    private Integer cnt;

    /**
     * 关联id
     */
    private Long subBizId;
    /**
     * 库存快照
     */
    private Integer stock;
    /**
     * 操作结果
     */
    private Integer result;
    /**
     * 评价
     */
    private Integer rating;
    /**
     * 建议
     */
    private String suggestion;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "orders_id")
    public Long getOrdersId() {
        return ordersId;
    }


    public void setOrdersId(Long ordersId) {
        this.ordersId = ordersId;
    }

    @Column(name = "biz_id")
    public Long getBizId() {
        return bizId;
    }


    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    @Column(name = "biz_type")
    public Integer getBizType() {
        return bizType;
    }


    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    @Column(name = "biz_title")
    public String getBizTitle() {
        return bizTitle;
    }

    public void setBizTitle(String bizTitle) {
        this.bizTitle = bizTitle;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "cnt")
    public Integer getCnt() {
        return cnt;
    }

    public void setCnt(Integer cnt) {
        this.cnt = cnt;
    }

    @Column(name = "sub_biz_id")
    public Long getSubBizId() {
        return subBizId;
    }

    public void setSubBizId(Long subBizId) {
        this.subBizId = subBizId;
    }

    @Column(name = "stock")
    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    @Column(name = "result")
    public Integer getResult() {
        return result;
    }

    public void setResult(Integer result) {
        this.result = result;
    }

    @Column(name = "rating")
    public Integer getRating() {
        return rating;
    }

    public void setRating(Integer rating) {
        this.rating = rating;
    }

    @Column(name = "suggestion")
    public String getSuggestion() {
        return suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

