package com.ptteng.fans.common.model;

import java.io.Serializable;
import javax.persistence.*;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "contents")
public class Contents implements Serializable {


    /**
     * 0：普通内容
     */
    public static final Integer ORDINARY = 0;

    /**
     * 10=行业模板添加内容
     */
    public static final Integer INDUSTRY = 10;

    /**
     * 上架状态
     */
    public static final Integer STATUS_ON = 1;
    /**
     * 下架状态
     */
    public static final Integer STATUS_OFF = 0;


    public static int IP_LIMITS_NO_LIMITS = 0;
    public static int IP_LIMITS_FIXED = 10;
    public static int IP_LIMITS_DYNAMIC = 15;

    public static final int STATUS_UN_START = 0;
    public static final int STATUS_IN_PROGRESS = 1;
    public static final int STATUS_FINISHED = 2;
    /**
     *
     */
    private static final long serialVersionUID = 7464906212372919296L;

    //多语言字段
    public static final String[] LANG_Field = new String[]{"title", "author", "content", "summary"};
    /**
     * id
     */
    private Long id;


    /**
     * 图片链接
     */
    private String img;

    /**
     * 首图.详情页的顶部图片
     */
    private String firstImg;

    /**
     * 视频URL
     */
    private String video;

    /**
     * 标题
     */
    private String title;


    private Integer ipLimitsWay;
    private String ipWhiteListInfo;

    /**
     * 排序
     */
    private Integer level;


    /**
     * 作者
     */
    private String author;


    /**
     * 内容
     */
    private String content;


    /**
     * 摘要
     */
    private String summary;


    /**
     * 链接(文章来源)
     */
    private String url;


    /**
     * 上下架  0 下架 1上架
     */
    private Integer status;


    /**
     * 应用类型
     */
    private Integer type;


    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 0：普通内容  10：行业模板添加内容
     */
    private Integer industryType;

    private Long readCount = 0L;

    /**
     * 创建人ID
     */
    private Long createBy;


    /**
     * 更新人ID
     */
    private Long updateBy;


    /**
     * 数据更新时间
     */
    private Long updateAt;


    /**
     * 数据创建时间
     */
    private Long createAt;

    private String keyword1;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "first_img")
    public String getFirstImg() {
        return firstImg;
    }

    public void setFirstImg(String firstImg) {
        this.firstImg = firstImg;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }
    /**
     * 副标题
     */
    private String subtitle;

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "level")
    public Integer getLevel() {
        return level;
    }


    public void setLevel(Integer level) {
        this.level = level;
    }

    @Column(name = "author")
    public String getAuthor() {
        return author;
    }


    public void setAuthor(String author) {
        this.author = author;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "summary")
    public String getSummary() {
        return summary;
    }


    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }


    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "industry_type")
    public Integer getIndustryType() {
        return industryType;
    }

    public void setIndustryType(Integer industryType) {
        this.industryType = industryType;
    }

    @Column(name = "video")
    public String getVideo() {
        return video;
    }

    public void setVideo(String video) {
        this.video = video;
    }


    @Column(name = "ip_limits_way")
    public Integer getIpLimitsWay() {
        return ipLimitsWay;
    }

    public void setIpLimitsWay(Integer ipLimitsWay) {
        this.ipLimitsWay = ipLimitsWay;
    }

    @Column(name = "ip_white_list_info")
    public String getIpWhiteListInfo() {
        return ipWhiteListInfo;
    }

    public void setIpWhiteListInfo(String ipWhiteListInfo) {
        this.ipWhiteListInfo = ipWhiteListInfo;
    }

    @Column(name = "read_count")
    public Long getReadCount() {
        return readCount;
    }

    public void setReadCount(Long readCount) {
        this.readCount = readCount;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }
    @Column(name = "subtitle")
    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public static final Integer IS_TOP = 1;
    public static final Integer IS_BANNER = 1;

    private Long startTime;
    private Long endTime;
    private Integer isTop;
    private Integer isBanner;
    private Integer favorCount;
    private Integer collectCount;
    private String serialNumber;
    private Integer activeStatus;
    @Transient
    public Integer getActiveStatus() {
        return activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    @Column(name = "serial_number")
    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Column(name = "start_time")
    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }
    @Column(name = "end_time")
    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }
    @Column(name = "is_top")
    public Integer getIsTop() {
        return isTop;
    }

    public void setIsTop(Integer isTop) {
        this.isTop = isTop;
    }
    @Column(name = "is_banner")
    public Integer getIsBanner() {
        return isBanner;
    }

    public void setIsBanner(Integer isBanner) {
        this.isBanner = isBanner;
    }
    @Column(name = "favor_count")
    public Integer getFavorCount() {
        return favorCount;
    }

    public void setFavorCount(Integer favorCount) {
        this.favorCount = favorCount;
    }
    @Column(name = "collect_count")
    public Integer getCollectCount() {
        return collectCount;
    }

    public void setCollectCount(Integer collectCount) {
        this.collectCount = collectCount;
    }

    @Column(name = "keyword_1")
    public String getKeyword1() {
        return keyword1;
    }

    public void setKeyword1(String keyword1) {
        this.keyword1 = keyword1;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

