/**
 * 
 */
package com.ptteng.sca.credit.user.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.credit.user.model.CommissionManagement;
import com.ptteng.credit.user.model.CommissionRecord;
import com.ptteng.credit.user.model.User;
import com.ptteng.credit.user.service.CommissionRecordService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class CommissionRecordSCAClient implements CommissionRecordService {

    private CommissionRecordService commissionRecordService;

	public CommissionRecordService getCommissionRecordService() {
		return commissionRecordService;
	}
	
	
	public void setCommissionRecordService(CommissionRecordService commissionRecordService) {
		this.commissionRecordService =commissionRecordService;
	}
	
	
			   
		@Override
		public Long insert(CommissionRecord commissionRecord)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.insert(commissionRecord);
		          
		
		}	
		  
    	   
		@Override
		public List<CommissionRecord> insertList(List<CommissionRecord> commissionRecordList)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.insertList(commissionRecordList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(CommissionRecord commissionRecord)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.update(commissionRecord);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<CommissionRecord> commissionRecordList)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.updateList(commissionRecordList);
		          
		
		}	
		  
    	   
		@Override
		public CommissionRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<CommissionRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public List<Long> getTotalSubByPage(int position, Long uid, String number, Integer page, Integer size, boolean isPage) throws ServiceException, ServiceDaoException {
		return commissionRecordService.getTotalSubByPage(position, uid, number, page, size, isPage);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCommissionRecordIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.getCommissionRecordIdsByUid(uid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCommissionRecordIdByBankId(Long bankId)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.getCommissionRecordIdByBankId(bankId);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCommissionRecordIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return commissionRecordService.countCommissionRecordIdsByUid(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getCommissionRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return commissionRecordService.getCommissionRecordIds(start, limit);
	}

	@Override
	public Integer countCommissionRecordIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return commissionRecordService.countCommissionRecordIds();
	}

	@Override
	public Integer userCommissionRecord(User user, BigDecimal commissionAmount, CommissionManagement commissionManagement, Long bankId, String bankName,boolean isNext) throws ServiceException, ServiceDaoException {
		return commissionRecordService.userCommissionRecord(user, commissionAmount,commissionManagement, bankId, bankName,isNext);
	}

	@Override
	public Integer calculationCommission(User user, BigDecimal commissionAmount, Long bankId, String bankName) throws ServiceException, ServiceDaoException {
		return commissionRecordService.calculationCommission(user, commissionAmount, bankId, bankName);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return commissionRecordService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return commissionRecordService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   commissionRecordService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.commissionRecordService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

