package com.ptteng.credit.user.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.credit.user.model.CommissionManagement;
import com.ptteng.credit.user.model.CommissionRecord;
import com.ptteng.credit.user.model.User;
import org.osoa.sca.annotations.Remotable;

import java.math.BigDecimal;
import java.util.List;

@Remotable
public interface CommissionRecordService extends BaseDaoService {


    public Long insert(CommissionRecord commissionRecord) throws ServiceException, ServiceDaoException;


    public List<CommissionRecord> insertList(List<CommissionRecord> commissionRecordList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CommissionRecord commissionRecord) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CommissionRecord> commissionRecordList) throws ServiceException, ServiceDaoException;


    public CommissionRecord getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CommissionRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;

    public List<Long> getTotalSubByPage(int position, Long uid, String number, Integer page,
                                        Integer size, boolean isPage) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCommissionRecordIdsByUid(Long uid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCommissionRecordIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getCommissionRecordIdByBankId(Long bankId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCommissionRecordIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCommissionRecordIds() throws ServiceException, ServiceDaoException;


    /**
     * 用户提成
     *
     * @param user                  当前办理信用卡用户
     * @param commissionAmount      当前办理成功银行卡分佣金额
     * @param bankId                当前申请银行id
     * @param bankName              当前申请银行名称
     * @param commissionManagement  当前分成百分比
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer userCommissionRecord(User user, BigDecimal commissionAmount, CommissionManagement commissionManagement, Long bankId, String bankName,boolean isNext) throws ServiceException, ServiceDaoException;

    /**
     * 计算用户提成
     *
     * @param user                  当前办理信用卡用户
     * @param commissionAmount      当前办理成功银行卡分佣金额
     * @param bankId                当前申请银行id
     * @param bankName              当前申请银行名称
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer calculationCommission(User user, BigDecimal commissionAmount, Long bankId, String bankName) throws ServiceException, ServiceDaoException;

}

