package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "bank_card_inquiry")
public class BankCardInquiry implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4067891272253787136L;

    /**
     * 银行上下架状态：0=下架
     */
    public static final Integer NOT_SHELF = 0;

    /**
     * 银行上下架状态：1=上架
     */
    public static final Integer SHELF = 1;

    /**
     * 申请量加1
     */
    public static final Integer PLUS_ONE = 1;

    /**
     * 勾选
     */
    public static final Integer CHECK = 1;

    /**
     * 光大银行	3	手机号+身份证+姓名+图片验证码+短信验证码
     */
    public static final String CHINA_EVERBRIGHT_BANK = "光大银行";

    /**
     * 广发银行	4	手机号+身份证+短信验证码
     */
    public static final String CHINA_GUANGFA_BANK = "广发银行";

    /**
     * 交通银行	7	手机号+身份证+图片验证码
     */
    public static final String BANK_OF_COMMUNICATIONS = "交通银行";

    /**
     * 民生银行	8	手机号+身份证+图片验证码+短信验证码
     */
    public static final String CHINA_MINGSHENG_BANK = "民生银行";

    /**
     * 平安银行	10	手机号+身份证+短信验证码
     */
    public static final String PINGAN_BANK = "平安银行";

    /**
     * 浦发银行	11	手机号+身份证+图片验证码
     */
    public static final String SHANGHAI_PUDONG_DEVELOPMENT_BANK = "浦发银行";

    /**
     * 兴业银行	13	手机号+身份证
     */
    public static final String INDUSTRIAL_BANK = "兴业银行";

    /**
     * 招商银行	14	手机号+身份证+图片验证码+短信验证码
     */
    public static final String CHINA_MERCHANTS_BANK = "招商银行";

    /**
     * 中信银行	16	手机号+身份证+短信验证码
     */
    public static final String CHINA_CITIC_BANK = "中信银行";

    /**
     * 上海银行	20	手机号+身份证
     */
    public static final String SHANGHAI_BANK = "上海银行";

    /**
     * 花旗银行	31	手机号+身份证+图片验证码
     */
    public static final String CITI_BANK = "花旗银行";

    /**
     * 约定：禁用=1，启动=2
     */
    public static final Integer DISABLE = 1;

    /**
     * 启动
     */
    public static final Integer START = 2;

    private Long id;


    private String bankName;

    /**
     * 申请量
     */
    private Integer applicationAmount = 0;


    private String img = "";


    private String url = "";


    private Integer status = 0;


    private Integer isName = 0;


    private Integer isIDCard = 0;


    private Integer isImageVerification = 0;


    private Integer isMobile = 0;


    private Integer isSms = 0;


    /**
     *约定：禁用=1，启动=2
     */
    private Integer isAutoQuery = START;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }


    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Column(name = "application_amount")
    public Integer getApplicationAmount() {
        return applicationAmount;
    }


    public void setApplicationAmount(Integer applicationAmount) {
        this.applicationAmount = applicationAmount;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "is_name")
    public Integer getIsName() {
        return isName;
    }


    public void setIsName(Integer isName) {
        this.isName = isName;
    }

    @Column(name = "is_id_card")
    public Integer getIsIDCard() {
        return isIDCard;
    }


    public void setIsIDCard(Integer isIDCard) {
        this.isIDCard = isIDCard;
    }

    @Column(name = "is_image_verification")
    public Integer getIsImageVerification() {
        return isImageVerification;
    }


    public void setIsImageVerification(Integer isImageVerification) {
        this.isImageVerification = isImageVerification;
    }

    @Column(name = "is_mobile")
    public Integer getIsMobile() {
        return isMobile;
    }


    public void setIsMobile(Integer isMobile) {
        this.isMobile = isMobile;
    }

    @Column(name = "is_sms")
    public Integer getIsSms() {
        return isSms;
    }


    public void setIsSms(Integer isSms) {
        this.isSms = isSms;
    }

    @Column(name = "is_auto_query")
    public Integer getIsAutoQuery() {
        return isAutoQuery;
    }


    public void setIsAutoQuery(Integer isAutoQuery) {
        this.isAutoQuery = isAutoQuery;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

