/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.AuthenticatedCipherText;
import com.nimbusds.jose.crypto.LegacyAESGCM;
import com.nimbusds.jose.util.ByteUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class AESGCM {
    public static final int IV_BIT_LENGTH = 96;
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom randomGen) {
        byte[] bytes = new byte[12];
        randomGen.nextBytes(bytes);
        return bytes;
    }

    public static AuthenticatedCipherText encrypt(SecretKey secretKey, byte[] iv, byte[] plainText, byte[] authData, Provider provider) throws JOSEException {
        byte[] cipherOutput;
        Cipher cipher;
        try {
            cipher = provider != null ? Cipher.getInstance("AES/GCM/NoPadding", provider) : Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, gcmSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new JOSEException("Couldn't create AES/GCM/NoPadding cipher: " + e.getMessage(), e);
        }
        catch (NoClassDefFoundError e) {
            return LegacyAESGCM.encrypt(secretKey, iv, plainText, authData);
        }
        cipher.updateAAD(authData);
        try {
            cipherOutput = cipher.doFinal(plainText);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new JOSEException("Couldn't encrypt with AES/GCM/NoPadding: " + e.getMessage(), e);
        }
        int tagPos = cipherOutput.length - ByteUtils.byteLength(128);
        byte[] cipherText = ByteUtils.subArray(cipherOutput, 0, tagPos);
        byte[] authTag = ByteUtils.subArray(cipherOutput, tagPos, ByteUtils.byteLength(128));
        return new AuthenticatedCipherText(cipherText, authTag);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] iv, byte[] cipherText, byte[] authData, byte[] authTag, Provider provider) throws JOSEException {
        Cipher cipher;
        try {
            cipher = provider != null ? Cipher.getInstance("AES/GCM/NoPadding", provider) : Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKey, gcmSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new JOSEException("Couldn't create AES/GCM/NoPadding cipher: " + e.getMessage(), e);
        }
        catch (NoClassDefFoundError e) {
            return LegacyAESGCM.decrypt(secretKey, iv, cipherText, authData, authTag);
        }
        cipher.updateAAD(authData);
        try {
            return cipher.doFinal(ByteUtils.concat(cipherText, authTag));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new JOSEException("AES/GCM/NoPadding decryption failed: " + e.getMessage(), e);
        }
    }

    private AESGCM() {
    }
}

