/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pollers {
    public static final String POLLERS = System.getProperty("servo.pollers", "60000");
    static final long[] POLLING_INTERVALS = Pollers.parse(POLLERS);
    private static final ImmutableList<Long> pollingIntervals;
    public static final int NUM_POLLERS;

    private Pollers() {
    }

    public static List<Long> getPollingIntervals() {
        return pollingIntervals;
    }

    static long[] parse(String pollers) {
        String[] periods = pollers.split(",\\s*");
        long[] result = new long[periods.length];
        long[] defaultPeriod = new long[]{60000L};
        boolean errors = false;
        Logger logger = LoggerFactory.getLogger(Pollers.class);
        for (int i = 0; i < periods.length; ++i) {
            String period = periods[i];
            try {
                result[i] = Long.parseLong(period);
                continue;
            }
            catch (NumberFormatException e) {
                logger.error("Cannot parse %s as a long " + e.getMessage());
                errors = true;
            }
        }
        if (errors || periods.length == 0) {
            logger.info("Using a default configuration of a poller with a {}ms interval", (Object)defaultPeriod[0]);
            return defaultPeriod;
        }
        return result;
    }

    static {
        NUM_POLLERS = POLLING_INTERVALS.length;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long pollingInterval : POLLING_INTERVALS) {
            builder.add((Object)pollingInterval);
        }
        pollingIntervals = builder.build();
    }
}

