/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Projectable;
import com.mysema.query.Tuple;
import com.mysema.query.group.AbstractGroupByTransformer;
import com.mysema.query.group.Group;
import com.mysema.query.group.GroupExpression;
import com.mysema.query.group.GroupImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.QTuple;
import java.util.LinkedHashMap;
import java.util.Map;

public class GroupByMap<K, V>
extends AbstractGroupByTransformer<K, Map<K, V>> {
    GroupByMap(Expression<K> key, Expression<?> ... expressions) {
        super(key, expressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> transform(Projectable projectable) {
        LinkedHashMap<Object, GroupImpl> groups = new LinkedHashMap<Object, GroupImpl>();
        FactoryExpression<Tuple> expr = FactoryExpressionUtils.wrap(new QTuple((Expression<?>[])this.expressions));
        boolean hasGroups = false;
        for (Expression<?> e : expr.getArgs()) {
            hasGroups |= e instanceof GroupExpression;
        }
        if (hasGroups) {
            expr = GroupByMap.withoutGroupExpressions(expr);
        }
        CloseableIterator<Tuple> iter = projectable.iterate(expr);
        try {
            while (iter.hasNext()) {
                Object[] row = ((Tuple)iter.next()).toArray();
                Object groupId = row[0];
                GroupImpl group = (GroupImpl)groups.get(groupId);
                if (group == null) {
                    group = new GroupImpl(this.groupExpressions, this.maps);
                    groups.put(groupId, group);
                }
                group.add(row);
            }
        }
        finally {
            iter.close();
        }
        return this.transform(groups);
    }

    protected Map<K, V> transform(Map<K, Group> groups) {
        return groups;
    }
}

