/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.models;

import com.microsoft.windowsazure.services.servicebus.implementation.Content;
import com.microsoft.windowsazure.services.servicebus.implementation.CorrelationFilter;
import com.microsoft.windowsazure.services.servicebus.implementation.EmptyRuleAction;
import com.microsoft.windowsazure.services.servicebus.implementation.Entry;
import com.microsoft.windowsazure.services.servicebus.implementation.EntryModel;
import com.microsoft.windowsazure.services.servicebus.implementation.FalseFilter;
import com.microsoft.windowsazure.services.servicebus.implementation.Filter;
import com.microsoft.windowsazure.services.servicebus.implementation.RuleAction;
import com.microsoft.windowsazure.services.servicebus.implementation.RuleDescription;
import com.microsoft.windowsazure.services.servicebus.implementation.SqlFilter;
import com.microsoft.windowsazure.services.servicebus.implementation.SqlRuleAction;
import com.microsoft.windowsazure.services.servicebus.implementation.TrueFilter;
import java.util.Calendar;

public class RuleInfo
extends EntryModel<RuleDescription> {
    public RuleInfo() {
        super(new Entry(), new RuleDescription());
        this.getEntry().setContent(new Content());
        this.getEntry().getContent().setType("application/xml");
        this.getEntry().getContent().setRuleDescription((RuleDescription)this.getModel());
    }

    public RuleInfo(Entry entry) {
        super(entry, entry.getContent().getRuleDescription());
    }

    public RuleInfo(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.getEntry().getTitle();
    }

    public RuleInfo setName(String value) {
        this.getEntry().setTitle(value);
        return this;
    }

    public Filter getFilter() {
        return ((RuleDescription)this.getModel()).getFilter();
    }

    public RuleInfo setFilter(Filter value) {
        ((RuleDescription)this.getModel()).setFilter(value);
        return this;
    }

    public RuleAction getAction() {
        return ((RuleDescription)this.getModel()).getAction();
    }

    public RuleInfo setAction(RuleAction value) {
        ((RuleDescription)this.getModel()).setAction(value);
        return this;
    }

    public RuleInfo withCorrelationIdFilter(String correlationId) {
        CorrelationFilter filter = new CorrelationFilter();
        filter.setCorrelationId(correlationId);
        return this.setFilter(filter);
    }

    public RuleInfo withSqlExpressionFilter(String sqlExpression) {
        SqlFilter filter = new SqlFilter();
        filter.setSqlExpression(sqlExpression);
        filter.setCompatibilityLevel(20);
        return this.setFilter(filter);
    }

    public RuleInfo withTrueFilter() {
        TrueFilter filter = new TrueFilter();
        filter.setCompatibilityLevel(20);
        filter.setSqlExpression("1=1");
        return this.setFilter(filter);
    }

    public RuleInfo withFalseFilter() {
        FalseFilter filter = new FalseFilter();
        filter.setCompatibilityLevel(20);
        filter.setSqlExpression("1=0");
        return this.setFilter(filter);
    }

    public RuleInfo withEmptyRuleAction() {
        EmptyRuleAction action = new EmptyRuleAction();
        return this.setAction(action);
    }

    public RuleInfo withSqlRuleAction(String sqlExpression) {
        SqlRuleAction action = new SqlRuleAction();
        action.setSqlExpression(sqlExpression);
        action.setCompatibilityLevel(20);
        return this.setAction(action);
    }

    public RuleInfo setTag(String tag) {
        ((RuleDescription)this.getModel()).setTag(tag);
        return this;
    }

    public String getTag() {
        return ((RuleDescription)this.getModel()).getTag();
    }

    public RuleInfo setCreatedAt(Calendar createdAt) {
        ((RuleDescription)this.getModel()).setCreatedAt(createdAt);
        return this;
    }

    public Calendar getCreatedAt() {
        return ((RuleDescription)this.getModel()).getCreatedAt();
    }
}

