/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.EncodingReservedUnitRestType;
import com.microsoft.windowsazure.services.media.models.EncodingReservedUnitInfo;
import com.microsoft.windowsazure.services.media.models.EncodingReservedUnitType;
import java.net.URI;

public final class EncodingReservedUnit {
    private static final String ENTITY_SET = "EncodingReservedUnitTypes";

    private EncodingReservedUnit() {
    }

    public static EntityGetOperation<EncodingReservedUnitInfo> get() {
        return new DefaultGetOperation<EncodingReservedUnitInfo>(ENTITY_SET, EncodingReservedUnitInfo.class);
    }

    public static Updater update(EncodingReservedUnitInfo encodingReservedUnitInfo) {
        return new Updater(encodingReservedUnitInfo);
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private int reservedUnitType;
        private int currentReservedUnits;

        protected Updater(final EncodingReservedUnitInfo encodingReservedUnitInfo) {
            super(new EntityOperationBase.EntityUriBuilder(){

                @Override
                public String getUri() {
                    URI uri = URI.create(String.format("%s(guid'%s')", EncodingReservedUnit.ENTITY_SET, encodingReservedUnitInfo.getAccountId()));
                    return uri.toString();
                }
            });
            this.setReservedUnitType(encodingReservedUnitInfo.getReservedUnitType());
            this.setCurrentReservedUnits(encodingReservedUnitInfo.getCurrentReservedUnits());
        }

        @Override
        public void setProxyData(EntityProxyData proxyData) {
        }

        @Override
        public Object getRequestContents() {
            EncodingReservedUnitRestType encodingReservedUnitType = new EncodingReservedUnitRestType();
            encodingReservedUnitType.setAccountId(null);
            encodingReservedUnitType.setCurrentReservedUnits(this.currentReservedUnits);
            encodingReservedUnitType.setReservedUnitType(this.reservedUnitType);
            return encodingReservedUnitType;
        }

        public Updater setCurrentReservedUnits(int currentReservedUnits) {
            this.currentReservedUnits = currentReservedUnits;
            return this;
        }

        public Updater setReservedUnitType(EncodingReservedUnitType encodingReservedUnitType) {
            this.reservedUnitType = encodingReservedUnitType.getCode();
            return this;
        }
    }
}

