/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ODataDateAdapter
extends XmlAdapter<String, Date> {
    private static final Pattern HAS_TIMEZONE_REGEX = Pattern.compile("^.*(\\+|-)\\d\\d:\\d\\d$");
    private static final TimeZone UTC = TimeZone.getDefault();

    public Date unmarshal(String dateString) throws Exception {
        if (!this.hasTimezone(dateString)) {
            dateString = dateString + "Z";
        }
        Calendar parsedDate = DatatypeConverter.parseDateTime((String)dateString);
        return parsedDate.getTime();
    }

    public String marshal(Date date) throws Exception {
        Calendar dateToMarshal = Calendar.getInstance();
        dateToMarshal.setTime(date);
        dateToMarshal.setTimeZone(UTC);
        return DatatypeConverter.printDateTime((Calendar)dateToMarshal);
    }

    private boolean hasTimezone(String dateString) {
        return dateString.endsWith("Z") || HAS_TIMEZONE_REGEX.matcher(dateString).matches();
    }

    static {
        UTC.setRawOffset(0);
    }
}

