/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter.support.io;

import com.marvinformatics.formatter.support.text.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Scanner;

public abstract class Resource {
    private final String path;
    private final String nativePath;

    protected Resource(String path) {
        this.path = Objects.requireNonNull(path, "path shall not be null");
        this.nativePath = path.substring(this.getPrefix().length() + 1);
    }

    public final String asString() throws UnknownResourceException {
        String result = null;
        try (InputStream stream = this.asInputStream();
             Scanner scanner = new Scanner(stream, StandardCharsets.UTF_8.name());){
            result = scanner.useDelimiter("\\A").next();
        }
        catch (IOException e) {
            throw new UnknownResourceException("Error loading resource", e);
        }
        return result;
    }

    public abstract InputStream asInputStream() throws UnknownResourceException;

    public abstract boolean exists();

    protected abstract String getPrefix();

    public final String getPath() {
        return this.path;
    }

    public final String getNativePath() {
        return this.nativePath;
    }

    public static Resource forPath(String path) {
        Resource resource = null;
        resource = path.startsWith("classpath:") ? new ClasspathResource(path) : (path.startsWith("file:") ? new FileResource(path) : Resource.forPath("file:" + path));
        return resource;
    }

    public static class UnknownResourceException
    extends Exception {
        public UnknownResourceException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnknownResourceException(String message) {
            super(message);
        }
    }

    static class FileResource
    extends Resource {
        private static final Template UNKNOWN = Template.as("Unknown resource %s");
        private static final Template NOT_FILE = Template.as("Resource not a file %s");
        private static final Template NOT_READ = Template.as("Resource not readable %s");
        public static final String PREFIX = "file";
        private final File file = new File(this.getNativePath());

        protected FileResource(String path) {
            super(path);
        }

        @Override
        public final String getPrefix() {
            return PREFIX;
        }

        @Override
        public InputStream asInputStream() throws UnknownResourceException {
            FileInputStream stream;
            if (!this.file.exists()) {
                throw new UnknownResourceException(UNKNOWN.format(this.getPath()));
            }
            if (!this.file.isFile()) {
                throw new UnknownResourceException(NOT_FILE.format(this.getPath()));
            }
            if (!this.file.canRead()) {
                throw new UnknownResourceException(NOT_READ.format(this.getPath()));
            }
            try {
                stream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new UnknownResourceException(NOT_READ.format(this.getPath()));
            }
            return stream;
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }
    }

    static class ClasspathResource
    extends Resource {
        public static final String PREFIX = "classpath";

        ClasspathResource(String path) {
            super(path);
        }

        @Override
        public final String getPrefix() {
            return PREFIX;
        }

        @Override
        public InputStream asInputStream() throws UnknownResourceException {
            InputStream is = this.getClass().getResourceAsStream(this.getNativePath());
            if (is == null) {
                throw new UnknownResourceException("Unknown resource at " + this.getPath());
            }
            return is;
        }

        @Override
        public boolean exists() {
            return this.getClass().getResource(this.getNativePath()) != null;
        }
    }
}

