/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.google.common.base.Stopwatch;
import com.marvinformatics.formatter.Result;
import java.util.concurrent.atomic.AtomicInteger;

public class ResultCollector {
    private final AtomicInteger successCount = new AtomicInteger();
    private final AtomicInteger failCount = new AtomicInteger();
    private final AtomicInteger skippedCount = new AtomicInteger();
    private final Stopwatch watch;

    public ResultCollector(Stopwatch watch) {
        this.watch = watch;
    }

    public void collect(Result result) {
        switch (result) {
            case SUCCESS: {
                this.successCount.incrementAndGet();
                break;
            }
            case FAIL: {
                this.failCount.incrementAndGet();
                break;
            }
            case SKIPPED: {
                this.skippedCount.incrementAndGet();
            }
        }
    }

    public int successCount() {
        return this.successCount.get();
    }

    public int failCount() {
        return this.failCount.get();
    }

    public int skippedCount() {
        return this.skippedCount.get();
    }

    public Stopwatch getWatch() {
        return this.watch;
    }
}

