/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.marvinformatics.formatter.FormatterMojo;
import com.marvinformatics.formatter.model.ConfigReader;
import com.marvinformatics.formatter.support.io.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.sonatype.plexus.build.incremental.BuildContext;

public class M2eConfigurer {
    private final FormatterMojo config;
    private final BuildContext buildContext;

    public M2eConfigurer(FormatterMojo config, BuildContext buildContext) {
        this.config = config;
        this.buildContext = buildContext;
    }

    public void configure() {
        try {
            this.setupEclipsePrefs(Resource.forPath(this.config.javaConfig()), ".settings/org.eclipse.jdt.core.prefs");
        }
        catch (Exception e) {
            this.buildContext.addMessage(new File(this.config.basedir, "pom.xml"), 3, 4, "Unable to configure jdt (Java) formatter", 2, (Throwable)e);
        }
        try {
            this.setupEclipsePrefs(Resource.forPath(this.config.jsConfig()), ".settings/org.eclipse.wst.jsdt.core.prefs");
        }
        catch (Exception e) {
            this.buildContext.addMessage(new File(this.config.basedir, "pom.xml"), 3, 4, "Unable to configure jsdt (Javascript) formatter", 2, (Throwable)e);
        }
    }

    private void setupEclipsePrefs(Resource configFile, String prefsPath) throws Exception {
        if (configFile.exists()) {
            Throwable throwable;
            Properties prefs = new Properties();
            File prefsFile = new File(this.config.basedir, prefsPath);
            if (prefsFile.exists()) {
                throwable = null;
                try (BufferedReader reader = Files.newReader((File)prefsFile, (Charset)Charsets.UTF_8);){
                    prefs.load(reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (InputStream configInput = configFile.asInputStream();){
                ConfigReader configReader = new ConfigReader();
                configReader.read(configInput).forEach(prefs::setProperty);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            throwable = null;
            try (OutputStream output = this.buildContext.newFileOutputStream(prefsFile);){
                prefs.store(output, "This file was touched by formatter-maven-plugin at:");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
    }
}

