/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.marvinformatics.formatter.CacheableFormatter;
import com.marvinformatics.formatter.Formatter;
import com.marvinformatics.formatter.FormatterMojo;
import com.marvinformatics.formatter.RecursiveWalk;
import com.marvinformatics.formatter.ResultCollector;
import com.marvinformatics.formatter.StreamIterable;
import com.marvinformatics.formatter.java.JavaFormatter;
import com.marvinformatics.formatter.javascript.JavascriptFormatter;
import com.marvinformatics.formatter.model.ConfigReadException;
import com.marvinformatics.formatter.model.ConfigReader;
import com.marvinformatics.formatter.support.io.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.AbstractScanner;
import org.codehaus.plexus.util.MatchPatterns;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.SAXException;

public class FormatterExecuter {
    private final FormatterMojo config;

    public FormatterExecuter(FormatterMojo config) {
        this.config = config;
    }

    public ResultCollector execute() {
        Stopwatch watch = Stopwatch.createStarted();
        ResultCollector rc = new ResultCollector(watch);
        if (StringUtils.isEmpty((String)this.config.encoding())) {
            String encoding = ReaderFactory.FILE_ENCODING;
        } else {
            String encoding = this.config.encoding();
            try {
                "Test Encoding".getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Encoding '" + encoding + "' is not supported", e);
            }
        }
        Stream pathsToScan = this.config.directories().stream();
        RecursiveWalk w = new RecursiveWalk(this.createJavaFormatter(), this.createJsFormatter(), rc, pathsToScan.filter(file -> this.isValidDirectory((File)file)).map(file -> file.toPath()), this.excludes());
        ForkJoinPool p = new ForkJoinPool(8);
        p.invoke(w);
        watch.stop();
        return rc;
    }

    private MatchPatterns excludes() {
        ArrayList excludes = this.config.excludes() != null ? Lists.newArrayList((Object[])this.config.excludes()) : Lists.newArrayList();
        excludes.addAll(Lists.newArrayList((Object[])AbstractScanner.DEFAULTEXCLUDES));
        return MatchPatterns.from(new StreamIterable<String>(excludes.stream().map(pattern -> this.normalize((String)pattern))));
    }

    private String normalize(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? StringUtils.replace((String)pattern, (String)"/", (String)"\\\\") : StringUtils.replace((String)pattern, (String)"\\\\", (String)"/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private ThreadLocal<CacheableFormatter> createJavaFormatter() {
        Supplier<Map> lazyConfig = () -> this.getFormattingOptions(this.config.javaConfig());
        return ThreadLocal.withInitial(() -> {
            Map formatterSettings = (Map)lazyConfig.get();
            this.config.getLog().debug((CharSequence)("Loading settings onto formatter: \n" + formatterSettings.entrySet()));
            return new CacheableFormatter(this.config, (Formatter)new JavaFormatter(formatterSettings, this.config.getCompilerSources(), this.config.getCompilerCompliance(), this.config.getCompilerCodegenTargetPlatform(), this.config.lineEnding()));
        });
    }

    private ThreadLocal<CacheableFormatter> createJsFormatter() {
        Supplier<Map> lazyConfig = () -> this.getFormattingOptions(this.config.jsConfig());
        return ThreadLocal.withInitial(() -> new CacheableFormatter(this.config, (Formatter)new JavascriptFormatter((Map)lazyConfig.get(), this.config.lineEnding())));
    }

    private boolean isValidDirectory(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    private Map<String, String> getFormattingOptions(String cfgFile) {
        if (cfgFile == null) {
            this.config.getLog().info((CharSequence)"No config file present");
            return new HashMap<String, String>();
        }
        this.config.getLog().info((CharSequence)("Reading config from " + cfgFile));
        Resource resource = Resource.forPath(cfgFile);
        if (!resource.exists()) {
            this.config.getLog().warn((CharSequence)("Config not found: " + cfgFile));
            return new HashMap<String, String>();
        }
        try {
            this.config.getLog().info((CharSequence)("Reading config from file: " + cfgFile));
            return this.getOptionsFromConfigFile(resource);
        }
        catch (MojoExecutionException e) {
            throw new IllegalStateException("Error loading Java config", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getOptionsFromConfigFile(Resource configFile) throws MojoExecutionException {
        try (InputStream configInput = configFile.asInputStream();){
            ConfigReader configReader = new ConfigReader();
            Map<String, String> map = configReader.read(configInput);
            return map;
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException("Cannot parse config file [" + configFile + "]", e);
        }
        catch (ConfigReadException | Resource.UnknownResourceException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

