/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.utils;

import com.ksyun.ks3.exception.Ks3ClientException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtils {
    public static Date convertStr2Date(String datetimeTxt, DATETIME_PROTOCOL protocol) {
        if (protocol.equals((Object)DATETIME_PROTOCOL.RFC1123)) {
            DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.ENGLISH);
            DateTime dt = RFC1123_DATE_TIME_FORMATTER.parseDateTime(datetimeTxt);
            return dt.toDate();
        }
        if (protocol.equals((Object)DATETIME_PROTOCOL.ISO8861)) {
            DateTimeFormatter ISO8861_FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
            DateTime dt = ISO8861_FORMATTER.parseDateTime(datetimeTxt);
            return dt.toDate();
        }
        return null;
    }

    public static Date convertStr2Date(String datetimeText, SimpleDateFormat sdf) {
        try {
            return sdf.parse(datetimeText);
        }
        catch (ParseException e) {
            throw new Ks3ClientException("\u65e0\u6cd5\u8f6c\u5316\u8be5\u65f6\u95f4\uff1a " + datetimeText, e);
        }
    }

    public static Date convertStr2Date(String datetimeText) {
        SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.UK);
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        if (datetimeText.contains("-") && datetimeText.contains("T")) {
            if (datetimeText.endsWith("Z")) {
                datetimeText = datetimeText.replace("Z", " GMT");
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            } else if (datetimeText.endsWith("+08:00")) {
                datetimeText = datetimeText.replace("+08:00", " GMT");
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            }
        }
        try {
            return sdf.parse(datetimeText);
        }
        catch (ParseException e) {
            throw new Ks3ClientException("\u65e0\u6cd5\u8f6c\u5316\u8be5\u65f6\u95f4\uff1a " + datetimeText, e);
        }
    }

    public static String convertDate2Str(Date date, DATETIME_PROTOCOL protocol) {
        if (protocol.equals((Object)DATETIME_PROTOCOL.RFC1123)) {
            DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.ENGLISH);
            return RFC1123_DATE_TIME_FORMATTER.print(date.getTime());
        }
        if (protocol.equals((Object)DATETIME_PROTOCOL.ISO8861)) {
            DateTimeFormatter ISO8861_FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
            return ISO8861_FORMATTER.print(date.getTime());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATETIME_PROTOCOL {
        RFC1123,
        ISO8861;

    }
}

