/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.InputSubStream;
import com.ksyun.ks3.LengthCheckInputStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.client.ClientFileNotFoundException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.SSECustomerKeyRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadPartRequest
extends Ks3WebServiceRequest
implements SSECustomerKeyRequest {
    private static final Log log = LogFactory.getLog(UploadPartRequest.class);
    private String bucket;
    private String key;
    private String uploadId;
    private int partNumber;
    private File file;
    private InputStream inputStream;
    private long partSize;
    private long fileoffset;
    private boolean lastPart = false;
    private SSECustomerKey sseCustomerKey;
    private String ContentMD5;

    public UploadPartRequest(String bucketname, String objectkey) {
        this.bucket = bucketname;
        this.key = objectkey;
    }

    public UploadPartRequest(String bucketname, String objectkey, String uploadId, int partNumber, File file, long partsize, long fileoffset) {
        this.bucket = bucketname;
        this.key = objectkey;
        this.setUploadId(uploadId);
        this.setPartNumber(partNumber);
        this.setFile(file);
        this.partSize = partsize;
        this.setFileoffset(fileoffset);
        if (file.length() - fileoffset <= this.partSize) {
            this.setLastPart(true);
        }
    }

    public UploadPartRequest(String bucketname, String objectkey, String uploadId, int partNumber, InputStream content, long partSize) {
        this.bucket = bucketname;
        this.key = objectkey;
        this.setUploadId(uploadId);
        this.setPartNumber(partNumber);
        this.setPartSize(partSize);
        this.inputStream = content;
    }

    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("uploadId");
        }
        if (this.partNumber < 1 || this.partNumber > 10000) {
            throw ClientIllegalArgumentExceptionGenerator.between("partNumber", String.valueOf(this.partNumber), String.valueOf(1), String.valueOf(10000));
        }
        if (this.file == null && this.inputStream == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("file(file to upload)", "inputStream(inputStream to upload)");
        }
        if (this.file != null) {
            if (this.fileoffset < 0L || this.fileoffset > this.file.length()) {
                throw ClientIllegalArgumentExceptionGenerator.between("fileoffset", String.valueOf(this.fileoffset), "0", String.valueOf(this.file.length()));
            }
        } else if (this.partSize <= 0L) {
            throw ClientIllegalArgumentExceptionGenerator.notNullInCondition("partSize", "upload part by inputstream");
        }
        if (this.partSize > 0x140000000L || this.partSize == 0L) {
            throw ClientIllegalArgumentExceptionGenerator.between("partsize", String.valueOf(this.partSize), "1", String.valueOf(0x140000000L));
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public long getInstancePartSize() {
        if (this.file != null) {
            long truesize = this.file.length() - this.fileoffset < this.partSize ? this.file.length() - this.fileoffset : this.partSize;
            return truesize;
        }
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public long getFileoffset() {
        return this.fileoffset;
    }

    public void setFileoffset(long fileoffset) {
        this.fileoffset = fileoffset;
    }

    public boolean isLastPart() {
        return this.lastPart;
    }

    public void setLastPart(boolean lastPart) {
        this.lastPart = lastPart;
    }

    public SSECustomerKey getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSseCustomerKey(SSECustomerKey sseCustomerKey) {
        this.sseCustomerKey = sseCustomerKey;
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addHeader(HttpHeaders.ContentType, "application/octet-stream");
        request.addQueryParam("uploadId", this.uploadId);
        request.addQueryParam("partNumber", String.valueOf(this.partNumber));
        if (this.file != null) {
            long truesize = this.getInstancePartSize();
            if (this.file.length() - this.fileoffset <= this.partSize) {
                this.setLastPart(true);
            }
            try {
                request.setContent(new LengthCheckInputStream(new InputSubStream(new RepeatableFileInputStream(this.file), this.fileoffset, truesize, true), truesize, true));
            }
            catch (FileNotFoundException e) {
                throw new ClientFileNotFoundException(e);
            }
        } else {
            request.setContent(new LengthCheckInputStream(this.inputStream, this.partSize, true));
        }
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.sseCustomerKey));
        request.addHeader(HttpHeaders.ContentLength, String.valueOf(this.getInstancePartSize()));
        if (!StringUtils.isBlank(this.ContentMD5)) {
            request.addHeader(HttpHeaders.ContentMD5, this.ContentMD5);
        }
    }

    public String getContentMD5() {
        return this.ContentMD5;
    }

    public void setContentMD5(String contentMD5) {
        this.ContentMD5 = contentMD5;
    }

    public void onFinally() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception e) {
                log.error((Object)("put object on finally close input stream err," + e.getMessage()));
            }
        }
    }
}

