/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.ResponseHeaderOverrides;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePresignedUrlRequest
extends Ks3WebServiceRequest {
    private HttpMethod method = HttpMethod.GET;
    private String bucket;
    private String key;
    private Date expiration;
    private String contentMD5;
    private String contentType;
    private Map<String, String> requestParameters = new HashMap<String, String>();
    private ResponseHeaderOverrides responseHeaders;
    private SSECustomerKey sseCustomerKey;
    private String sseAlgorithm;

    @Override
    public void buildRequest(Request request) {
        request.setMethod(this.method);
        if (!StringUtils.isBlank(this.bucket)) {
            request.setBucket(this.bucket);
        }
        if (!StringUtils.isBlank(this.key)) {
            request.setKey(this.key);
        }
        if (!StringUtils.isBlank(this.contentMD5)) {
            request.addHeader(HttpHeaders.ContentMD5, this.contentMD5);
        }
        if (!StringUtils.isBlank(this.contentType)) {
            request.addHeader(HttpHeaders.ContentType, this.contentType);
        }
        if (this.requestParameters != null) {
            request.getQueryParams().putAll(this.requestParameters);
        }
        if (this.responseHeaders != null) {
            request.getQueryParams().putAll(this.responseHeaders.getOverrides());
        }
        if (this.sseCustomerKey != null) {
            request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.sseCustomerKey));
        }
        if (!StringUtils.isBlank(this.sseAlgorithm)) {
            request.addHeader(HttpHeaders.XKssServerSideEncryption, this.sseAlgorithm);
        }
        if (this.expiration != null) {
            request.setExpires(this.expiration);
        } else {
            request.setExpires(new Date(System.currentTimeMillis() + 900000L));
        }
    }

    @Override
    public void validateParams() {
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public SSECustomerKey getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSseCustomerKey(SSECustomerKey sseCustomerKey) {
        this.sseCustomerKey = sseCustomerKey;
    }

    public String getSseAlgorithm() {
        return this.sseAlgorithm;
    }

    public void setSseAlgorithm(String sseAlgorithm) {
        this.sseAlgorithm = sseAlgorithm;
    }
}

