/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMultipleObjectsRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String[] keys = new String[0];

    public DeleteMultipleObjectsRequest(String bucketName, List<String> keys) {
        this.bucket = bucketName;
        this.keys = keys.toArray(this.keys);
    }

    public DeleteMultipleObjectsRequest(String bucketName, String[] keys) {
        this.bucket = bucketName;
        this.keys = keys;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (this.keys == null || this.keys.length == 0) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("keys");
        }
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.POST);
        request.setBucket(this.bucket);
        request.getQueryParams().put("delete", "");
        XmlWriter writer = new XmlWriter();
        writer.start("Delete");
        for (int i = 0; i < this.keys.length; ++i) {
            writer.start("Object").start("Key").value(this.keys[i]).end().end();
        }
        writer.end();
        String xml = writer.toString();
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }
}

