/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.dto.CompleteMultipartUploadResult;
import com.ksyun.ks3.dto.CopyResult;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.dto.PutObjectResult;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.service.encryption.S3Direct;
import com.ksyun.ks3.service.encryption.internal.ByteRangeCapturingInputStream;
import com.ksyun.ks3.service.encryption.internal.CipherFactory;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoScheme;
import com.ksyun.ks3.service.encryption.internal.EncryptedUploadContext;
import com.ksyun.ks3.service.encryption.internal.EncryptionInstruction;
import com.ksyun.ks3.service.encryption.internal.EncryptionUtils;
import com.ksyun.ks3.service.encryption.internal.JceEncryptionConstants;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModuleBase;
import com.ksyun.ks3.service.encryption.internal.S3CryptoScheme;
import com.ksyun.ks3.service.encryption.model.CryptoConfiguration;
import com.ksyun.ks3.service.encryption.model.CryptoStorageMode;
import com.ksyun.ks3.service.encryption.model.EncryptedInitiateMultipartUploadRequest;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterials;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsProvider;
import com.ksyun.ks3.service.encryption.model.MaterialsDescriptionProvider;
import com.ksyun.ks3.service.request.CompleteMultipartUploadRequest;
import com.ksyun.ks3.service.request.CopyPartRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import java.io.File;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class S3CryptoModuleEO
extends S3CryptoModuleBase<EncryptedUploadContext> {
    S3CryptoModuleEO(S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(s3, encryptionMaterialsProvider, cryptoConfig, new S3CryptoScheme(ContentCryptoScheme.AES_CBC));
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(putObjectRequest, "ks3-kss-java-sdk/ks3encryptionclient/v0.6.2");
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            return this.putObjectUsingInstructionFile(putObjectRequest);
        }
        return this.putObjectUsingMetadata(putObjectRequest);
    }

    @Override
    public GetObjectResult getObjectSecurely(GetObjectRequest getObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        throw new IllegalStateException();
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) throws Ks3ClientException, Ks3ServiceException {
        throw new IllegalStateException();
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(completeMultipartUploadRequest, "ks3-kss-java-sdk/ks3encryptionclient/v0.6.2");
        String uploadId = completeMultipartUploadRequest.getUploadId();
        EncryptedUploadContext encryptedUploadContext = (EncryptedUploadContext)this.multipartUploadContexts.get(uploadId);
        if (!encryptedUploadContext.hasFinalPartBeenSeen()) {
            throw new Ks3ClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in KS3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult result = this.s3.completeMultipartUpload(completeMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            Cipher symmetricCipher = EncryptionUtils.createSymmetricCipher(encryptedUploadContext.getEnvelopeEncryptionKey(), 1, this.cryptoConfig.getCryptoProvider(), encryptedUploadContext.getFirstInitializationVector());
            EncryptionMaterials encryptionMaterials = encryptedUploadContext.getMaterialsDescription() != null ? this.kekMaterialsProvider.getEncryptionMaterials(encryptedUploadContext.getMaterialsDescription()) : this.kekMaterialsProvider.getEncryptionMaterials();
            byte[] encryptedEnvelopeSymmetricKey = EncryptionUtils.getEncryptedSymmetricKey(encryptedUploadContext.getEnvelopeEncryptionKey(), encryptionMaterials, this.cryptoConfig.getCryptoProvider());
            EncryptionInstruction instruction = new EncryptionInstruction(encryptionMaterials.getMaterialsDescription(), encryptedEnvelopeSymmetricKey, encryptedUploadContext.getEnvelopeEncryptionKey(), symmetricCipher);
            this.s3.putObject(EncryptionUtils.createInstructionPutRequest(encryptedUploadContext.getBucketName(), encryptedUploadContext.getKey(), instruction));
        }
        this.multipartUploadContexts.remove(uploadId);
        return result;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(initiateMultipartUploadRequest, "ks3-kss-java-sdk/ks3encryptionclient/v0.6.2");
        SecretKey envelopeSymmetricKey = EncryptionUtils.generateOneTimeUseSymmetricKey();
        Cipher symmetricCipher = EncryptionUtils.createSymmetricCipher(envelopeSymmetricKey, 1, this.cryptoConfig.getCryptoProvider(), null);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            EncryptionMaterials encryptionMaterials = null;
            encryptionMaterials = initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest ? this.kekMaterialsProvider.getEncryptionMaterials(((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).getMaterialsDescription()) : this.kekMaterialsProvider.getEncryptionMaterials();
            byte[] encryptedEnvelopeSymmetricKey = EncryptionUtils.getEncryptedSymmetricKey(envelopeSymmetricKey, encryptionMaterials, this.cryptoConfig.getCryptoProvider());
            ObjectMetadata metadata = EncryptionUtils.updateMetadataWithEncryptionInfo(initiateMultipartUploadRequest, encryptedEnvelopeSymmetricKey, symmetricCipher, encryptionMaterials.getMaterialsDescription());
            initiateMultipartUploadRequest.setObjectMeta(metadata);
        }
        InitiateMultipartUploadResult result = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest);
        EncryptedUploadContext encryptedUploadContext = new EncryptedUploadContext(initiateMultipartUploadRequest.getBucket(), initiateMultipartUploadRequest.getKey(), envelopeSymmetricKey);
        encryptedUploadContext.setNextInitializationVector(symmetricCipher.getIV());
        encryptedUploadContext.setFirstInitializationVector(symmetricCipher.getIV());
        if (initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest) {
            encryptedUploadContext.setMaterialsDescription(((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).getMaterialsDescription());
        }
        this.multipartUploadContexts.put(result.getUploadId(), encryptedUploadContext);
        return result;
    }

    @Override
    public PartETag uploadPartSecurely(UploadPartRequest uploadPartRequest) throws Ks3ClientException, Ks3ServiceException {
        boolean partSizeMultipleOfCipherBlockSize;
        this.appendUserAgent(uploadPartRequest, "ks3-kss-java-sdk/ks3encryptionclient/v0.6.2");
        boolean isLastPart = uploadPartRequest.isLastPart();
        String uploadId = uploadPartRequest.getUploadId();
        boolean bl = partSizeMultipleOfCipherBlockSize = uploadPartRequest.getInstancePartSize() % (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE == 0L;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new Ks3ClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE + ") with the exception of the last part.  " + "Otherwise encryption adds extra padding that will corrupt the final object.");
        }
        EncryptedUploadContext encryptedUploadContext = (EncryptedUploadContext)this.multipartUploadContexts.get(uploadId);
        if (encryptedUploadContext == null) {
            throw new Ks3ClientException("No client-side information available on upload ID " + uploadId);
        }
        SecretKey envelopeSymmetricKey = encryptedUploadContext.getEnvelopeEncryptionKey();
        byte[] iv = encryptedUploadContext.getNextInitializationVector();
        CipherFactory cipherFactory = new CipherFactory(envelopeSymmetricKey, 1, iv, this.cryptoConfig.getCryptoProvider());
        ByteRangeCapturingInputStream encryptedInputStream = EncryptionUtils.getEncryptedInputStream(uploadPartRequest, cipherFactory);
        uploadPartRequest.setInputStream(encryptedInputStream);
        if (uploadPartRequest.isLastPart()) {
            long cryptoContentLength = EncryptionUtils.calculateCryptoContentLength(cipherFactory.createCipher(), uploadPartRequest);
            if (cryptoContentLength > 0L) {
                uploadPartRequest.setPartSize(cryptoContentLength);
            }
            if (encryptedUploadContext.hasFinalPartBeenSeen()) {
                throw new Ks3ClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part, otherwise it will cause the encrypted data to be corrupted.");
            }
            encryptedUploadContext.setHasFinalPartBeenSeen(true);
        }
        uploadPartRequest.setFile(null);
        uploadPartRequest.setFileoffset(0L);
        PartETag result = this.s3.uploadPart(uploadPartRequest);
        encryptedUploadContext.setNextInitializationVector(encryptedInputStream.getBlock());
        return result;
    }

    @Override
    public CopyResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String uploadId = copyPartRequest.getUploadId();
        EncryptedUploadContext encryptedUploadContext = (EncryptedUploadContext)this.multipartUploadContexts.get(uploadId);
        if (!encryptedUploadContext.hasFinalPartBeenSeen()) {
            encryptedUploadContext.setHasFinalPartBeenSeen(true);
        }
        return this.s3.copyPart(copyPartRequest);
    }

    private PutObjectResult putObjectUsingMetadata(PutObjectRequest putObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        EncryptionInstruction instruction = this.encryptionInstructionOf(putObjectRequest);
        PutObjectRequest encryptedObjectRequest = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, instruction);
        EncryptionUtils.updateMetadataWithEncryptionInstruction(putObjectRequest, instruction);
        return this.s3.putObject(encryptedObjectRequest);
    }

    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        EncryptionInstruction instruction = this.encryptionInstructionOf(putObjectRequest);
        PutObjectRequest encryptedObjectRequest = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, instruction);
        PutObjectResult encryptedObjectResult = this.s3.putObject(encryptedObjectRequest);
        PutObjectRequest instructionRequest = EncryptionUtils.createInstructionPutRequest(putObjectRequest, instruction);
        this.s3.putObject(instructionRequest);
        return encryptedObjectResult;
    }

    private EncryptionInstruction encryptionInstructionOf(Ks3WebServiceRequest req) {
        EncryptionInstruction instruction;
        if (req instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider p = (MaterialsDescriptionProvider)((Object)req);
            instruction = EncryptionUtils.generateInstruction(this.kekMaterialsProvider, p.getMaterialsDescription(), this.cryptoConfig.getCryptoProvider());
        } else {
            instruction = EncryptionUtils.generateInstruction(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider());
        }
        return instruction;
    }

    @Override
    protected final long ciphertextLength(long plaintextLength) {
        long cipherBlockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }
}

