/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;

public class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private IOException originalException;

    public RepeatableInputStreamRequestEntity(InputStream content, String length) {
        this.setChunked(false);
        long contentLength = -1L;
        try {
            String contentLengthString = length;
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        this.inputStreamRequestEntity = new InputStreamEntity(content, contentLength);
        this.inputStreamRequestEntity.setContentType(this.contentType);
        this.content = content;
        this.setContent(content);
        this.setContentType(this.contentType);
        this.setContentLength(contentLength);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    public void writeTo(OutputStream output) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            this.inputStreamRequestEntity.writeTo(output);
        }
        catch (IOException ioe) {
            if (this.originalException == null) {
                this.originalException = ioe;
            }
            throw this.originalException;
        }
    }
}

