/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.ServerSideEncryptionResult;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.utils.StringUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMetadata
implements ServerSideEncryptionResult {
    private String usermeta_prefix = Constants.userMetaPrefix;
    private Map<String, String> userMetadata = new HashMap<String, String>();
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private Date httpExpiresDate;

    public String toString() {
        return StringUtils.object2string(this);
    }

    public void setUserMeta(String key, String value) {
        this.userMetadata.put(key.startsWith(this.usermeta_prefix) ? key : this.usermeta_prefix + key, value);
    }

    public String getUserMeta(String key) {
        return this.userMetadata.get(key.startsWith(this.usermeta_prefix) ? key : this.usermeta_prefix + key);
    }

    public boolean containsUserMeta(String key) {
        return this.userMetadata.containsKey(key.startsWith(this.usermeta_prefix) ? key : this.usermeta_prefix + key);
    }

    public Map<String, String> getAllUserMeta() {
        return this.userMetadata;
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.metadata));
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get(HttpHeaders.LastModified.toString());
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put(HttpHeaders.LastModified.toString(), lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get(HttpHeaders.ContentLength.toString());
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get(HttpHeaders.ContentRange.toString());
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.metadata.put(HttpHeaders.ContentLength.toString(), contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get(HttpHeaders.ContentType.toString());
    }

    public void setContentType(String contentType) {
        this.metadata.put(HttpHeaders.ContentType.toString(), contentType);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get(HttpHeaders.ContentEncoding.toString());
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put(HttpHeaders.ContentEncoding.toString(), encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get(HttpHeaders.CacheControl.toString());
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put(HttpHeaders.CacheControl.toString(), cacheControl);
    }

    public String getContentMD5() {
        return (String)this.metadata.get(HttpHeaders.ContentMD5.toString());
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove(HttpHeaders.ContentMD5.toString());
        } else {
            this.metadata.put(HttpHeaders.ContentMD5.toString(), md5Base64);
        }
    }

    public String getContentDisposition() {
        return (String)this.metadata.get(HttpHeaders.ContentDisposition.toString());
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put(HttpHeaders.ContentDisposition.toString(), disposition);
    }

    public String getETag() {
        return (String)this.metadata.get(HttpHeaders.ETag.toString());
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    @Override
    public String getSseAlgorithm() {
        return (String)this.metadata.get(HttpHeaders.XKssServerSideEncryption.toString());
    }

    @Override
    public void setSseAlgorithm(String value) {
        this.metadata.put(HttpHeaders.XKssServerSideEncryption.toString(), value);
    }

    @Override
    public String getSseKMSKeyId() {
        return (String)this.metadata.get(HttpHeaders.XKssServerSideEncryptionKMSKeyId.toString());
    }

    @Override
    public void setSseKMSKeyId(String value) {
        this.metadata.put(HttpHeaders.XKssServerSideEncryptionKMSKeyId.toString(), value);
    }

    @Override
    public String getSseCustomerAlgorithm() {
        return (String)this.metadata.get(HttpHeaders.XKssServerSideEncryptionCustomerAlgorithm.toString());
    }

    @Override
    public void setSseCustomerAlgorithm(String value) {
        this.metadata.put(HttpHeaders.XkssServerSideEncryptionCustomerKey.toString(), value);
    }

    @Override
    public String getSseCustomerKeyMD5() {
        return (String)this.metadata.get(HttpHeaders.XkssServerSideEncryptionCustomerKeyMD5.toString());
    }

    @Override
    public void setSseCustomerKeyMD5(String value) {
        this.metadata.put(HttpHeaders.XkssServerSideEncryptionCustomerKeyMD5.toString(), value);
    }

    public Object getMeta(String key) {
        return this.metadata.get(key);
    }
}

