/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5DigestCalculatingInputStream
extends FilterInputStream {
    private MessageDigest digest;
    private byte[] lastDigest;

    public MD5DigestCalculatingInputStream(InputStream in) {
        super(in);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("unexpected", e);
        }
    }

    public byte[] getMd5Digest() {
        if (this.lastDigest == null) {
            this.lastDigest = this.digest.digest();
            return this.lastDigest;
        }
        return this.lastDigest;
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
    }

    public void reset() throws IOException {
        super.reset();
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.lastDigest = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("unexpected", e);
        }
    }

    public int read() throws IOException {
        int ch = super.read();
        if (ch != -1) {
            this.lastDigest = null;
            this.digest.update((byte)ch);
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this.lastDigest = null;
            this.digest.update(b, off, result);
        }
        return result;
    }
}

