/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.id.impl;

import com.lenovo.vctl.dal.id.IdCreator;
import com.lenovo.vctl.dal.id.TimeIdHelper;
import com.lenovo.vctl.dal.id.exception.CreateIdException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;

public class TimeIdCreator
implements IdCreator {
    private ConcurrentMap<String, AtomicLong> automicLongMap = new ConcurrentHashMap<String, AtomicLong>();
    private Integer idc = null;

    @Override
    public Long nextId(String sKey) throws CreateIdException {
        if (StringUtils.isEmpty((String)sKey)) {
            throw new CreateIdException("sKey must have value");
        }
        String atomicKey = sKey;
        AtomicLong seqAtomic = (AtomicLong)this.automicLongMap.get(atomicKey);
        if (seqAtomic == null) {
            AtomicLong memAtomic = new AtomicLong(0L);
            seqAtomic = this.automicLongMap.putIfAbsent(atomicKey, memAtomic);
            seqAtomic = seqAtomic == null ? memAtomic : seqAtomic;
        }
        return TimeIdHelper.getIdByDate(System.currentTimeMillis(), seqAtomic, (int)this.idc);
    }

    public TimeIdCreator(Integer idc) {
        this.idc = idc;
    }
}

