/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.util;

import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.config.model.dao.ListItem;
import com.lenovo.vctl.dal.dao.config.model.dao.MapItem;
import com.lenovo.vctl.dal.dao.model.LsCacheInfo;
import com.lenovo.vctl.dal.dao.model.ScalarInfo;
import com.lenovo.vctl.dal.dao.model.SqlInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class SqlUtil {
    private static Log log = LogFactory.getLog(SqlUtil.class);

    public static SqlInfo getMappingSqlInfo(String mappingName, Object[] params, boolean bExtend) {
        SqlInfo sqlInfo = null;
        MapItem mapItem = DaoHelper.getMapItemByMapName(mappingName);
        String sql = mapItem.getSqlitem();
        if (!bExtend) {
            String column = DaoHelper.getMapItemValueColumnName(mappingName);
            Type type = TypeFactory.basic((String)DaoHelper.getMapItemValueClass(mappingName).getName());
            ScalarInfo scalarInfo = new ScalarInfo(column, type);
            ArrayList<ScalarInfo> scaList = new ArrayList<ScalarInfo>();
            scaList.add(scalarInfo);
            sqlInfo = new SqlInfo(sql, params, scaList);
        } else {
            sqlInfo = new SqlInfo(sql, params, null);
        }
        return sqlInfo;
    }

    public static SqlInfo getListSql(String listName, Object[] params) {
        SqlInfo sqlInfo = null;
        String sql = null;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        sql = listItem.getSqlitem();
        String iDColumn = listItem.getColumnName();
        if (iDColumn.toLowerCase().contains("distinct ".toLowerCase())) {
            iDColumn = iDColumn.replaceAll("distinct", "");
        }
        Type type = TypeFactory.basic((String)DaoHelper.getListItemValueClass(listName).getName());
        ScalarInfo scalarInfo = new ScalarInfo(iDColumn.trim(), type);
        ArrayList<ScalarInfo> scaList = new ArrayList<ScalarInfo>();
        scaList.add(scalarInfo);
        sqlInfo = new SqlInfo(sql, params, scaList);
        return sqlInfo;
    }

    public static SqlInfo getListSql(LsCacheInfo lsHelper) {
        if (lsHelper == null || lsHelper.getRegion() == null) {
            return null;
        }
        return SqlUtil.getListSql(lsHelper.getRegion(), lsHelper.getParams());
    }

    public static SqlInfo getListCountSql(String listName, Object[] params) {
        SqlInfo sqlInfo = null;
        String sql = null;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        sql = listItem.getSqlcountitem();
        sqlInfo = new SqlInfo(sql, params, null);
        return sqlInfo;
    }

    public static SqlInfo getListCountSql(LsCacheInfo lsHelper) {
        return SqlUtil.getListCountSql(lsHelper.getRegion(), lsHelper.getParams());
    }

    public static List<SqlInfo> getMapAggreSqlInfos(String mapName, List<Object[]> paramsList) {
        MapItem mapItem = DaoHelper.getMapItemByMapName(mapName);
        return SqlUtil.getUnionSql(paramsList, mapItem.getSqlitem(), null);
    }

    public static List<SqlInfo> getUnionSql(List<Object[]> paramsList, String baseSql, List<Type> returnTypes) {
        ArrayList<SqlInfo> sqlInfoList = new ArrayList<SqlInfo>();
        int unionCnt = 30;
        int leftCnts = paramsList.size() % 30;
        int fullCnts = paramsList.size() / 30;
        int i = 0;
        while (i < fullCnts) {
            String sql = SqlUtil.getAggrSql(baseSql, 30);
            int start = i * 30;
            int end = (i + 1) * 30;
            Object[] realParams = SqlUtil.getAggrParams(paramsList.subList(start, end));
            if (realParams != null) {
                SqlInfo sqlInfo = new SqlInfo(sql, realParams, null);
                sqlInfoList.add(sqlInfo);
            }
            ++i;
        }
        if (leftCnts > 0) {
            String sql = SqlUtil.getAggrSql(baseSql, leftCnts);
            Object[] realParams = SqlUtil.getAggrParams(paramsList = paramsList.subList(fullCnts * 30, paramsList.size()));
            if (realParams != null) {
                SqlInfo sqlInfo = new SqlInfo(sql, realParams, null);
                sqlInfoList.add(sqlInfo);
            }
        }
        return sqlInfoList;
    }

    public static List<SqlInfo> getEntityUnionSql(List idList, String baseSql) {
        List<SqlInfo> sqlInfoList = null;
        if (idList.size() > 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (Object id : idList) {
                if (id == null) continue;
                paramsList.add(new Object[]{id});
            }
            if (paramsList.size() > 0) {
                return SqlUtil.getUnionSql(paramsList, baseSql, null);
            }
        }
        return sqlInfoList;
    }

    public static String getAggrSql(String sql, int count) {
        StringBuffer allSql = new StringBuffer();
        int i = 0;
        while (i < count) {
            if (i < count - 1) {
                allSql.append(sql).append(" union all ");
            } else {
                allSql.append(sql);
            }
            ++i;
        }
        return allSql.toString();
    }

    public static Object[] getAggrParams(List<Object[]> paramsList) {
        ArrayList<Object> aggrList = new ArrayList<Object>();
        Iterator<Object[]> iterator = paramsList.iterator();
        while (iterator.hasNext()) {
            Object[] params;
            Object[] objectArray = params = iterator.next();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                if (param == null) {
                    return null;
                }
                aggrList.add(param);
                ++n2;
            }
        }
        return aggrList.toArray();
    }

    public static void main(String[] args) {
        ArrayList<Object[]> newList = new ArrayList<Object[]>();
        int i = 21;
        while (i > 0) {
            newList.add(new Object[]{1});
            --i;
        }
        List<SqlInfo> sqlInfoList = SqlUtil.getUnionSql(newList, "select * from tables where id =?", null);
        for (SqlInfo sqlIfo : sqlInfoList) {
            System.out.println(" =========Sql ========\r\n");
            System.out.println(sqlIfo.getSql());
        }
    }
}

