/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.util;

import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.config.model.dao.ListItem;
import com.lenovo.vctl.dal.dao.config.model.dao.MapItem;
import com.lenovo.vctl.dal.dao.config.model.method.ItemMethod;
import com.lenovo.vctl.dal.dao.model.LsCacheInfo;
import com.lenovo.vctl.dal.dao.model.MapInfo;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUtil {
    private static final Log log = LogFactory.getLog(ObjectUtil.class);

    public static Object[] getParams(ItemMethod item, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods = item.getKeyMethod();
        if (methods == null || methods.length < 1 || object == null) {
            return null;
        }
        Object[] params = new Object[methods.length];
        int i = 0;
        while (i < methods.length) {
            Object propValue;
            if (methods[i] != null) {
                propValue = methods[i].invoke(object, new Object[0]);
                if (propValue == null) {
                    return null;
                }
            } else {
                return null;
            }
            params[i] = propValue;
            ++i;
        }
        return params;
    }

    public static Object[] getOrderByParams(ListItem item, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods = item.getOrderByMethod();
        if (methods == null || methods.length < 1 || object == null) {
            return null;
        }
        Object[] params = new Object[methods.length];
        int i = 0;
        while (i < methods.length) {
            Object propValue;
            if (methods[i] != null) {
                propValue = methods[i].invoke(object, new Object[0]);
                if (propValue == null) {
                    return null;
                }
            } else {
                return null;
            }
            params[i] = propValue;
            ++i;
        }
        return params;
    }

    public static Object getObjectValueOfList(Object obj, LsCacheInfo lsInfo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ListItem listItem = DaoHelper.getListItemByListName(lsInfo.getRegion());
        Method method = listItem.getValueMethod();
        if (method == null) {
            return null;
        }
        Object valueOfObj = method.invoke(obj, new Object[0]);
        return valueOfObj;
    }

    public static Serializable getObjectId(Object object) throws Exception {
        Method method = DaoHelper.getIdMethod(object.getClass());
        if (method == null) {
            return null;
        }
        return (Serializable)method.invoke(object, new Object[0]);
    }

    public static List<MapInfo> getMapInfoList(Object object) throws Exception {
        ArrayList<MapInfo> list = new ArrayList<MapInfo>();
        List<MapItem> mapList = DaoHelper.getMapItemsByObjectName(object.getClass().getName());
        if (mapList != null && mapList.size() > 0) {
            for (MapItem item : mapList) {
                Object[] params;
                String region;
                if (item == null || StringUtils.isBlank((String)(region = item.getName())) || (params = ObjectUtil.getParams(item, object)) == null || params.length < 1) continue;
                Method method = item.getValueMethod();
                if (method == null) {
                    log.info((Object)"Attention: Value Method in MapItem is null \r\n");
                    continue;
                }
                Object value = method.invoke(object, new Object[0]);
                if (value == null) continue;
                list.add(new MapInfo(region, params, value));
            }
        }
        return list;
    }

    public static List<LsCacheInfo> getLsInfoList(Object object) throws Exception {
        ArrayList<LsCacheInfo> list = new ArrayList<LsCacheInfo>();
        List<ListItem> listItemList = DaoHelper.getListItemsByObjectName(object.getClass().getName());
        if (listItemList != null && listItemList.size() > 0) {
            for (ListItem item : listItemList) {
                Object[] params;
                String region;
                if (item == null || StringUtils.isEmpty((String)(region = item.getName())) || (params = ObjectUtil.getParams(item, object)) == null || params.length < 1) continue;
                Object[] orderByParams = ObjectUtil.getOrderByParams(item, object);
                if (orderByParams != null) {
                    int cfr_ignored_0 = orderByParams.length;
                }
                LsCacheInfo info = new LsCacheInfo(region, params, orderByParams, item.getLimitLen(), item.getInitLen(), item.isUpdate());
                list.add(info);
            }
        }
        return list;
    }

    public static Object getObjectStrategyPropert(Object obj) throws Exception {
        Method method = DaoHelper.getStrategyPropertyMethod(obj.getClass().getName());
        if (method == null) {
            return null;
        }
        return method.invoke(obj, new Object[0]);
    }
}

