/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.util;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.exception.CacheException;
import com.lenovo.vctl.dal.cache.memcached.CacheFactoryImpl;
import com.lenovo.vctl.dal.dao.helper.LogHelper;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheHelper {
    private static Log log = LogFactory.getLog(CacheHelper.class);

    public static Cache getListCache(String regionName) {
        Cache cache = CacheFactoryImpl.getInstance().getCache(regionName, Boolean.TRUE.booleanValue());
        if (cache == null) {
            LogHelper.cacheDontConfigured(log, regionName);
        }
        return cache;
    }

    public static Cache getClassCache(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return CacheHelper.getListCache(clazz.getName());
    }

    public static Cache getObjectCache(Object object) {
        if (object == null) {
            return null;
        }
        return CacheHelper.getListCache(object.getClass().toString());
    }

    public static void put(String region, String key, Object value) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null) {
            cache.put(key, value);
        }
    }

    public static void save(Class objCls, Serializable id, Object obj) throws CacheException {
        Cache cache = CacheHelper.getClassCache(objCls);
        if (cache != null) {
            cache.save(id.toString(), obj);
        }
    }

    public static Object get(String region, String key) throws CacheException {
        Object obj = null;
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null && key != null) {
            obj = cache.get(key);
        }
        return obj;
    }

    public static Object[] gets(String region, List keyLs) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null && keyLs != null && keyLs.size() > 0) {
            return cache.get(keyLs.toArray(new String[keyLs.size()]));
        }
        return null;
    }

    public static void delete(String region, String key) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null && key != null) {
            cache.delete(key);
        }
    }

    public static void remove(String region, String key) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null) {
            cache.remove(key);
        }
    }

    public static void update(String region, String key, Object value) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null) {
            cache.update(key, value);
        }
    }

    public static boolean isDelete(String region, String key) throws CacheException {
        boolean res = true;
        Cache cache = CacheHelper.getListCache(region);
        if (cache != null) {
            res = cache.isDelete(key);
        }
        return res;
    }
}

