/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.listener;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.MaxIdHolder;
import com.lenovo.vctl.dal.cache.NullObjectContent;
import com.lenovo.vctl.dal.dao.DaoRecord;
import com.lenovo.vctl.dal.dao.Listener;
import com.lenovo.vctl.dal.dao.model.LsCacheInfo;
import com.lenovo.vctl.dal.dao.model.MapInfo;
import com.lenovo.vctl.dal.dao.util.CacheHelper;
import com.lenovo.vctl.dal.dao.util.NullObjectHelper;
import com.lenovo.vctl.dal.dao.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;

public class DefaultListener
implements Listener {
    private long wait_time = 3000L;
    private static Logger logger = Logger.getLogger(DefaultListener.class);
    private static final Integer LISTWAITTIME = 20;
    DaoRecord record = DaoRecord.getInstance();

    @Override
    public void onSaveBegin(Object account_id, Object entity) throws Exception {
    }

    @Override
    public void onSaveCompleted(Object account_id, Class cls, Serializable id, Object entity) throws Exception {
        List<MapInfo> mapInfos;
        this.record.NotifyEntitySaveComplete(entity.getClass().getName(), ObjectUtils.toString((Object)id));
        CacheHelper.save(cls, id, entity);
        List<LsCacheInfo> lsCacheInfos = ObjectUtil.getLsInfoList(entity);
        if (CollectionUtils.isNotEmpty(lsCacheInfos)) {
            for (LsCacheInfo lsInfo : lsCacheInfos) {
                Cache cache = CacheHelper.getListCache(lsInfo.getRegion());
                if (cache == null) continue;
                if (this.waitCntListLoadIng(lsInfo)) {
                    cache.remove(lsInfo.getListCntKey());
                } else {
                    cache.incr(lsInfo.getListCntKey(), 1L);
                }
                if (lsInfo.isUpdate() || this.waitListLoadIng(lsInfo)) {
                    cache.remove(lsInfo.getKey());
                    cache.remove(lsInfo.getListCntKey());
                } else {
                    cache.ladd(lsInfo.getKey(), "" + id);
                }
                this.record.NotifyListAddNewObject(lsInfo);
            }
        }
        if (CollectionUtils.isNotEmpty(mapInfos = ObjectUtil.getMapInfoList(entity))) {
            for (MapInfo mapInfo : mapInfos) {
                this.record.NotifyMappingAddNewObject(mapInfo);
            }
        }
        NullObjectHelper.removeNullMapsOfObject(entity);
        NullObjectContent.remove((String)("NULL_" + cls.getName() + id));
        MaxIdHolder.setMaxId((String)("MaxId_" + cls.getName()), (Long)Long.parseLong("" + id));
    }

    @Override
    public void onSaveEnd(Object account_id, Serializable id, Object entity) throws Exception {
    }

    @Override
    public void onSaveError(Object account_id, Serializable id, Object entity) {
    }

    @Override
    public void onBatchSaveCompleted(Object account_id, Class cls, Map idObjMap) throws Exception {
        Long maxObjectId = 0L;
        ArrayList objList = new ArrayList();
        for (Map.Entry entry : idObjMap.entrySet()) {
            List<MapInfo> mapInfos;
            Serializable id = (Serializable)entry.getKey();
            Object obj = entry.getValue();
            objList.add(obj);
            CacheHelper.save(cls, id, obj);
            this.record.NotifyEntitySaveComplete(cls.getName(), ObjectUtils.toString((Object)id));
            List<LsCacheInfo> lsCacheInfos = ObjectUtil.getLsInfoList(obj);
            if (CollectionUtils.isNotEmpty(lsCacheInfos)) {
                for (LsCacheInfo lsInfo : lsCacheInfos) {
                    Cache cache = CacheHelper.getListCache(lsInfo.getRegion());
                    if (cache != null) {
                        cache.remove(lsInfo.getListCntKey());
                        cache.remove(lsInfo.getKey());
                    }
                    this.record.NotifyListAddNewObject(lsInfo);
                }
            }
            if (CollectionUtils.isNotEmpty(mapInfos = ObjectUtil.getMapInfoList(obj))) {
                for (MapInfo mapInfo : mapInfos) {
                    this.record.NotifyMappingAddNewObject(mapInfo);
                }
            }
            NullObjectHelper.removeNullMapsOfObject(obj);
            NullObjectContent.remove((String)("NULL_" + obj.getClass().getName() + id));
            if (new Long("" + id) <= maxObjectId) continue;
            maxObjectId = new Long("" + id);
        }
        if (maxObjectId > 0L) {
            MaxIdHolder.setMaxId((String)("MaxId_" + objList.get(0).getClass().getName()), (Long)maxObjectId);
        }
    }

    @Override
    public void onUpdateBegin(Object account_id, Serializable id, Object obj, Object oldObj) throws Exception {
    }

    @Override
    public void onUpdateCompleted(Object account_id, Serializable id, Object obj, Object oldObj) throws Exception {
        Object cache;
        String region;
        this.record.NotifyEntityUpdateCompleted(obj.getClass().getName(), id.toString());
        List<LsCacheInfo> allInfolist = ObjectUtil.getLsInfoList(obj);
        HashMap<String, LsCacheInfo> objInfoMap = new HashMap<String, LsCacheInfo>();
        for (LsCacheInfo lsInfo : allInfolist) {
            String region2 = lsInfo.getRegion();
            Cache cache2 = CacheHelper.getListCache(region2);
            if (cache2 == null) continue;
            objInfoMap.put(region2, lsInfo);
        }
        List<LsCacheInfo> oldAllInfolist = ObjectUtil.getLsInfoList(oldObj);
        HashMap<String, LsCacheInfo> oldInfoMap = new HashMap<String, LsCacheInfo>();
        for (LsCacheInfo lsInfo : oldAllInfolist) {
            region = lsInfo.getRegion();
            cache = CacheHelper.getListCache(region);
            if (cache == null) continue;
            oldInfoMap.put(region, lsInfo);
        }
        for (Map.Entry entry : oldInfoMap.entrySet()) {
            region = (String)entry.getKey();
            cache = CacheHelper.getListCache(region);
            LsCacheInfo oldLsInfo = (LsCacheInfo)entry.getValue();
            LsCacheInfo newLsInfo = (LsCacheInfo)objInfoMap.get(region);
            String oldKey = oldLsInfo.getKey();
            String newKey = newLsInfo.getKey();
            String oldOrderByKey = oldLsInfo.getOrderByKey();
            String newOrderByKey = newLsInfo.getOrderByKey();
            Object oldValueOfLs = ObjectUtil.getObjectValueOfList(oldObj, oldLsInfo);
            Object newValueOfLs = ObjectUtil.getObjectValueOfList(obj, newLsInfo);
            if (oldKey.equalsIgnoreCase(newKey) && oldValueOfLs.equals(newValueOfLs) && (oldOrderByKey == null || oldOrderByKey.length() <= 0 || oldOrderByKey.equalsIgnoreCase(newOrderByKey))) continue;
            this.waitCntListLoadIng(oldLsInfo);
            cache.remove(oldLsInfo.getListCntKey());
            this.waitListLoadIng(oldLsInfo);
            cache.remove(oldLsInfo.getKey());
            this.record.NotifyListAddNewObject(oldLsInfo);
            if (oldKey.equalsIgnoreCase(newKey)) continue;
            this.waitCntListLoadIng(newLsInfo);
            cache.remove(newLsInfo.getListCntKey());
            this.waitListLoadIng(newLsInfo);
            cache.remove(newLsInfo.getKey());
            this.record.NotifyListAddNewObject(newLsInfo);
        }
        List<MapInfo> oldMaps = ObjectUtil.getMapInfoList(oldObj);
        for (MapInfo info : oldMaps) {
            Cache cache3 = CacheHelper.getListCache(info.getRegion());
            if (cache3 == null) continue;
            this.record.NotifyMappingAddNewObject(info);
            cache3.remove(info.getKey());
        }
        List<MapInfo> newMaps = ObjectUtil.getMapInfoList(obj);
        for (MapInfo info : newMaps) {
            Cache cache4 = CacheHelper.getListCache(info.getRegion());
            if (cache4 == null) continue;
            this.record.NotifyMappingAddNewObject(info);
            cache4.put(info.getKey(), info.getValue());
        }
        NullObjectHelper.removeNullMapsOfObject(obj);
        CacheHelper.update(obj.getClass().getName(), "" + id, obj);
    }

    @Override
    public void onUpdateEnd(Object account_id, Serializable id, Object obj, Object oldObj) throws Exception {
    }

    @Override
    public void onUpdateError(Object account_id, Serializable id, Object obj, Object oldObj) {
    }

    @Override
    public void onDeleteCompleted(Object account_id, Serializable id, Object obj) throws Exception {
        this.record.NotifyEntityDeleteComplated(obj.getClass().getName(), id.toString());
        List<LsCacheInfo> lsCacheInfos = ObjectUtil.getLsInfoList(obj);
        if (CollectionUtils.isNotEmpty(lsCacheInfos)) {
            for (LsCacheInfo lsInfo : lsCacheInfos) {
                Cache cache = CacheHelper.getListCache(lsInfo.getRegion());
                if (cache == null) continue;
                this.waitCntListLoadIng(lsInfo);
                cache.remove(lsInfo.getListCntKey());
                this.waitListLoadIng(lsInfo);
                cache.remove(lsInfo.getKey());
                this.record.NotifyListRemoveObject(lsInfo);
            }
        }
        List<MapInfo> oldMaps = ObjectUtil.getMapInfoList(obj);
        for (MapInfo info : oldMaps) {
            Cache cache = CacheHelper.getListCache(info.getRegion());
            if (cache == null) continue;
            cache.remove(info.getKey());
            this.record.NotifyMappingChangeComplated(info);
        }
        CacheHelper.delete(obj.getClass().getName(), "" + id);
    }

    @Override
    public void onDeleteBegin(Object account_id, Serializable id, Object obj) throws Exception {
    }

    @Override
    public void onDeleteEnd(Object account_id, Serializable id, Object obj, Object oldObject) throws Exception {
    }

    @Override
    public void onDeleteError(Object account_id, Serializable id, Object obj) {
    }

    @Override
    public void onBatchSaveBegin(Object account_id, List objList) throws Exception {
    }

    @Override
    public void onBatchSaveEnd(Object account_id, List objList) {
    }

    private boolean waitCntListLoadIng(LsCacheInfo lsCacheInfo) {
        long currentTime = System.currentTimeMillis();
        boolean waitSucess = false;
        while (this.record.isCntListLoading(lsCacheInfo)) {
            if (System.currentTimeMillis() - currentTime > this.wait_time) {
                logger.info((Object)"check loading is timeout");
                break;
            }
            waitSucess = true;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return waitSucess;
    }

    private boolean waitListLoadIng(LsCacheInfo lsCacheInfo) {
        long currentTime = System.currentTimeMillis();
        boolean waitSucess = false;
        while (this.record.isListLoading(lsCacheInfo)) {
            if (System.currentTimeMillis() - currentTime > this.wait_time) {
                logger.info((Object)"check loading is timeout");
                break;
            }
            waitSucess = true;
        }
        return waitSucess;
    }
}

