/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.impl;

import com.lenovo.vctl.dal.dao.DBAgent;
import com.lenovo.vctl.dal.dao.Dao;
import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.config.model.dao.ObjectItem;
import com.lenovo.vctl.dal.dao.datasource.ContextHolder;
import com.lenovo.vctl.dal.dao.exception.DaoException;
import com.lenovo.vctl.dal.dao.helper.LogHelper;
import com.lenovo.vctl.dal.dao.impl.CompositeDaoImpl;
import com.lenovo.vctl.dal.dao.impl.DBAgentHibernateImpl;
import com.lenovo.vctl.dal.dao.model.SqlInfo;
import com.lenovo.vctl.dal.dao.route.RoutingService;
import com.lenovo.vctl.dal.dao.util.DalAssert;
import com.lenovo.vctl.dal.dao.util.ObjectUtil;
import com.lenovo.vctl.dal.dao.util.SqlUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;

public class HibernateDaoImpl
implements Dao {
    private static final int singleUsedTime = 15;
    private static final int lotsUsedTime = 50;
    private Log log = LogFactory.getLog(CompositeDaoImpl.class);
    private Log permLog = LogFactory.getLog((String)"DalPerformance");
    private DBAgent dbAgent = DBAgentHibernateImpl.getInstance();

    @Override
    public Serializable save(Object account_id, Object object) throws DaoException {
        long usedTime;
        DalAssert.assertObjectNotNull(object);
        DalAssert.assertObjectIllegal(account_id, object);
        long t1 = System.currentTimeMillis();
        Serializable id = null;
        try {
            RoutingService.getInstance().setRoutingStrategyForObject(object.getClass(), account_id, null, 2);
            id = this.dbAgent.save(account_id, object);
            if (id == null) {
                LogHelper.savedError(this.log, object);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: save region: " + object.getClass().getName() + " params: " + id + " time: " + usedTime));
        }
        return id;
    }

    @Override
    public Serializable save(Object object) throws DaoException {
        return this.save(null, object);
    }

    @Override
    public List save(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(account_id, objects);
        ArrayList objList = new ArrayList();
        for (Object obj : objects) {
            if (obj == null) continue;
            this.save(account_id, obj);
            objList.add(obj);
        }
        return objList;
    }

    @Override
    public List save(List objects) throws DaoException {
        return this.save(null, objects);
    }

    @Override
    public List batchSave(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        ArrayList<Object> objList = new ArrayList<Object>();
        try {
            Map<Serializable, Object> objMap = this.batchSaveReturnMap(account_id, objects);
            if (objMap != null && objMap.size() > 0) {
                for (Map.Entry<Serializable, Object> entry : objMap.entrySet()) {
                    Serializable id = entry.getKey();
                    if (id == null) continue;
                    objList.add(objMap.get(id));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return objList;
    }

    @Override
    public List batchSave(List objects) throws DaoException {
        return this.batchSave(null, objects);
    }

    public Map<Serializable, Object> batchSaveReturnMap(Object account_id, List objects) throws DaoException {
        Object obj;
        long t1 = System.currentTimeMillis();
        HashMap idObjMap = null;
        try {
            RoutingService.getInstance().setRoutingStrategyForObject(objects.get(0).getClass(), account_id, null, 2);
            idObjMap = this.dbAgent.save(account_id, objects);
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 50L && this.permLog.isWarnEnabled() && (obj = objects.get(0)) != null && obj.getClass() != null) {
            this.permLog.warn((Object)("method: BatchSave region: " + objects.get(0).getClass().getName() + " size: " + objects.size() + " time: " + usedTime));
        }
        if (idObjMap == null) {
            idObjMap = new HashMap();
        }
        return idObjMap;
    }

    @Override
    public boolean update(Object account_id, Object object) throws DaoException {
        long usedTime;
        DalAssert.assertObjectNotNull(object);
        DalAssert.assertObjectIllegal(account_id, object);
        long t1 = System.currentTimeMillis();
        Serializable objectId = null;
        boolean bUpdated = true;
        try {
            objectId = ObjectUtil.getObjectId(object);
            if (objectId == null) {
                LogHelper.failedGetObjectId(this.log, object);
                return bUpdated;
            }
            RoutingService.getInstance().setRoutingStrategyForObject(object.getClass(), account_id, null, 2);
            bUpdated = this.dbAgent.update(account_id, object);
            if (!bUpdated) {
                LogHelper.updateError(this.log, object);
            }
        }
        catch (Exception e) {
            bUpdated = false;
            this.processException(e);
        }
        if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: update region: " + object.getClass().getName() + " params: " + objectId + " time: " + usedTime));
        }
        return bUpdated;
    }

    @Override
    public boolean update(Object object) throws DaoException {
        return this.update(null, object);
    }

    @Override
    public boolean batchUpdate(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(account_id, objects);
        boolean bUpdated = true;
        try {
            for (Object obj : objects) {
                this.update(account_id, obj);
            }
        }
        catch (Exception e) {
            bUpdated = false;
            this.processException(e);
        }
        return bUpdated;
    }

    @Override
    public boolean batchUpdate(List objects) throws DaoException {
        return this.batchUpdate(null, objects);
    }

    @Override
    public boolean delete(Object account_id, Class clazz, Serializable id) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        boolean bDeleted = true;
        Object obj = null;
        try {
            obj = this.get(account_id, clazz, id);
            if (obj == null) {
                LogHelper.failedGetObjectById(this.log, account_id, clazz, id);
                return bDeleted;
            }
            RoutingService.getInstance().setRoutingStrategyForObject(clazz, account_id, null, 2);
            bDeleted = this.dbAgent.delete(account_id, obj);
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: realDelete region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return bDeleted;
    }

    @Override
    public boolean delete(Class clazz, Serializable id) throws DaoException {
        return this.delete(null, clazz, id);
    }

    @Override
    public boolean deleteList(Object account_id, Class clazz, List ids) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        boolean bDeleted = true;
        try {
            for (Object id : ids) {
                this.delete(account_id, clazz, (Serializable)id);
            }
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        return bDeleted;
    }

    @Override
    public boolean deleteList(Class clazz, List ids) throws DaoException {
        return this.deleteList(null, clazz, ids);
    }

    @Override
    public boolean deleteList(Object account_id, String list_name, Object[] params) throws DaoException {
        boolean res;
        block3: {
            String clsName;
            List idList;
            block4: {
                DalAssert.assertObjectNotNull(list_name);
                DalAssert.assertObjectNotNull(params);
                res = true;
                idList = this.getIdList(account_id, list_name, params);
                if (idList == null || idList.size() <= 0) break block3;
                clsName = DaoHelper.getObjectNameByListName(list_name);
                if (!StringUtils.isEmpty((String)clsName)) break block4;
                LogHelper.failedGetClassNameByListName(this.log, list_name);
                return true;
            }
            try {
                res = this.deleteList(account_id, Class.forName(clsName), idList);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return res;
    }

    @Override
    public boolean deleteList(String list_name, Object[] params) throws DaoException {
        return this.deleteList((Object)null, list_name, params);
    }

    @Override
    public boolean deleteList(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.deleteList(account_id, list_name, new Object[0]);
        }
        return this.deleteList(account_id, list_name, new Object[]{param});
    }

    @Override
    public boolean deleteList(String list_name, Object param) throws DaoException {
        return this.deleteList(null, list_name, param);
    }

    @Override
    public boolean fakeDelete(Object account_id, Class clazz, Serializable id) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        boolean bDeleted = true;
        Object obj = null;
        try {
            obj = this.get(account_id, clazz, id);
            if (obj == null) {
                LogHelper.failedGetObjectById(this.log, account_id, clazz, id);
                return bDeleted;
            }
            RoutingService.getInstance().setRoutingStrategyForObject(clazz, account_id, null, 2);
            Method method = DaoHelper.getDelPropertyMethod(obj.getClass().getName());
            Object delTag = DaoHelper.getDelValue(obj.getClass().getName());
            DalAssert.assertObjectNotNull(method);
            DalAssert.assertObjectNotNull(delTag);
            method.invoke(obj, delTag);
            this.dbAgent.update(account_id, obj);
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: fakeDelete region: " + obj.getClass().getName() + " params: " + id + " time: " + usedTime));
        }
        return bDeleted;
    }

    @Override
    public boolean fakeDelete(Class clazz, Serializable id) throws DaoException {
        return this.fakeDelete(null, clazz, id);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, Class clazz, List ids) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        boolean bDeleted = true;
        try {
            for (Object id : ids) {
                this.fakeDelete(account_id, clazz, (Serializable)id);
            }
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        return bDeleted;
    }

    @Override
    public boolean fakeDeleteList(Class clazz, List ids) throws DaoException {
        return this.fakeDeleteList(null, clazz, ids);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, String list_name, Object[] params) throws DaoException {
        boolean res;
        block3: {
            String clsName;
            List idList;
            block4: {
                DalAssert.assertObjectNotNull(list_name);
                DalAssert.assertObjectNotNull(params);
                res = true;
                idList = this.getIdList(account_id, list_name, params);
                if (idList == null || idList.size() <= 0) break block3;
                clsName = DaoHelper.getObjectNameByListName(list_name);
                if (!StringUtils.isEmpty((String)clsName)) break block4;
                LogHelper.failedGetClassNameByListName(this.log, list_name);
                return true;
            }
            try {
                res = this.fakeDeleteList(account_id, Class.forName(clsName), idList);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return res;
    }

    @Override
    public boolean fakeDeleteList(String list_name, Object[] params) throws DaoException {
        return this.fakeDeleteList((Object)null, list_name, params);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.fakeDeleteList(account_id, list_name, new Object[0]);
        }
        return this.fakeDeleteList(account_id, list_name, new Object[]{param});
    }

    @Override
    public boolean fakeDeleteList(String list_name, Object param) throws DaoException {
        return this.fakeDeleteList(null, list_name, param);
    }

    @Override
    public int count(Object account_id, String listName, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(listName);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        SqlInfo sqlInfo = null;
        int count = 0;
        try {
            sqlInfo = SqlUtil.getListCountSql(listName, params);
            RoutingService.getInstance().setRoutingStrategyForList(listName, account_id, params, 1);
            count = this.dbAgent.count(account_id, listName, sqlInfo);
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled() && sqlInfo != null) {
            this.permLog.warn((Object)("method: count region: " + listName + " params: " + sqlInfo.getParamKey() + " time: " + usedTime));
        }
        return count;
    }

    @Override
    public int count(String list_name, Object[] params) throws DaoException {
        return this.count((Object)null, list_name, params);
    }

    @Override
    public int count(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.count(account_id, list_name, new Object[0]);
        }
        return this.count(account_id, list_name, new Object[]{param});
    }

    @Override
    public int count(String list_name, Object param) throws DaoException {
        return this.count(null, list_name, param);
    }

    @Override
    public Object get(Object account_id, Class clazz, Serializable id) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            RoutingService.getInstance().setRoutingStrategyForObject(clazz, account_id, id, 1);
            obj = this.dbAgent.get(account_id, clazz, id);
            DalAssert.assertObjectIllegal(account_id, obj);
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: get region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object get(Class clazz, Serializable id) throws DaoException {
        return this.get(null, clazz, id);
    }

    @Override
    public List getIdList(Object account_id, String listName, Object[] params, Integer start, Integer count) throws DaoException {
        long usedTime;
        DalAssert.assertObjectNotNull(listName);
        DalAssert.assertObjectNotNull(params);
        DalAssert.assertObjectNotNull(start);
        DalAssert.assertObjectNotNull(count);
        long t1 = System.currentTimeMillis();
        List idList = new ArrayList();
        SqlInfo sqlInfo = null;
        try {
            sqlInfo = SqlUtil.getListSql(listName, params);
            if (sqlInfo != null) {
                RoutingService.getInstance().setRoutingStrategyForList(listName, account_id, params, 1);
                idList = this.dbAgent.getIdList(account_id, listName, sqlInfo, start, count);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled() && sqlInfo.getParams() != null) {
            this.permLog.warn((Object)("method: getIdList region: " + listName + " params: " + sqlInfo.getParamKey() + " time: " + usedTime + " start :" + start + " count :" + count + "\r\n" + " sql: " + sqlInfo.getSql()));
        }
        return idList;
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object[] params) throws DaoException {
        int totalCount = this.count(account_id, list_name, params);
        if (totalCount <= 0) {
            return new ArrayList();
        }
        return this.getIdList(account_id, list_name, params, (Integer)0, (Integer)totalCount);
    }

    @Override
    public List getIdList(String list_name, Object[] params) throws DaoException {
        return this.getIdList((Object)null, list_name, params);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.getIdList(account_id, list_name, new Object[0]);
        }
        return this.getIdList(account_id, list_name, new Object[]{param});
    }

    @Override
    public List getIdList(String list_name, Object param) throws DaoException {
        return this.getIdList(null, list_name, param);
    }

    @Override
    public List getIdList(String list_name, Object[] params, Integer start, Integer count) throws DaoException {
        return this.getIdList((Object)null, list_name, params, start, count);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object param, Integer start, Integer count) throws DaoException {
        if (param == null) {
            return this.getIdList(account_id, list_name, new Object[0], start, count);
        }
        return this.getIdList(account_id, list_name, new Object[]{param}, start, count);
    }

    @Override
    public List getIdList(String list_name, Object param, Integer start, Integer count) throws DaoException {
        return this.getIdList(null, list_name, param, start, count);
    }

    @Override
    public List getIdList(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        return this.getMappings(accountId, mapName, paramsList);
    }

    @Override
    public List getIdList(String mapName, List<Object[]> paramsList) throws DaoException {
        return this.getIdList(null, mapName, paramsList);
    }

    @Override
    public List getList(Object account_id, Class clazz, List ids) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        long t1 = System.currentTimeMillis();
        ArrayList objList = new ArrayList();
        try {
            ObjectItem objItem = DaoHelper.getObjectItemByObjectName(clazz.getName());
            String baseSql = objItem.getEntitySql();
            if (baseSql == null || StringUtils.isEmpty((String)baseSql)) {
                return objList;
            }
            List<SqlInfo> sqlInfoLs = SqlUtil.getEntityUnionSql(ids, baseSql);
            if (sqlInfoLs == null || sqlInfoLs.size() == 0) {
                return objList;
            }
            RoutingService.getInstance().setRoutingStrategyForObject(clazz, account_id, ids.get(0), 1);
            for (SqlInfo sqlInfo : sqlInfoLs) {
                List entityLs = this.dbAgent.getEntityList(account_id, clazz, sqlInfo, 1);
                objList.addAll(entityLs);
            }
            return objList;
        }
        catch (Exception e) {
            this.processException(e);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getList region: " + clazz.getName() + " size: " + ids.size() + " time: " + usedTime));
            }
            return objList;
        }
    }

    @Override
    public List getList(Class clazz, List ids) throws DaoException {
        return this.getList(null, clazz, ids);
    }

    @Override
    public Object getMapping(Object account_id, String mappingName, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(mappingName);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            SqlInfo sqlInfo = SqlUtil.getMappingSqlInfo(mappingName, params, false);
            RoutingService.getInstance().setRoutingStrategyForMap(mappingName, account_id, params, 1);
            obj = this.dbAgent.getMapping(account_id, mappingName, sqlInfo);
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: getMapping region: " + mappingName + " size: " + params.length + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object getMapping(String mappingName, Object[] keys) throws DaoException {
        return this.getMapping((Object)null, mappingName, keys);
    }

    @Override
    public Object getMapping(Object account_id, String mappingName, Object key) throws DaoException {
        if (key == null) {
            return this.getMapping(account_id, mappingName, new Object[0]);
        }
        return this.getMapping(account_id, mappingName, new Object[]{key});
    }

    @Override
    public Object getMapping(String mappingName, Object key) throws DaoException {
        return this.getMapping(null, mappingName, key);
    }

    public Object getExtendMapping(Object account_id, String mappingName, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(mappingName);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            SqlInfo sqlInfo = SqlUtil.getMappingSqlInfo(mappingName, params, true);
            RoutingService.getInstance().setRoutingStrategyForMap(mappingName, account_id, params, 1);
            obj = this.dbAgent.getMapping(account_id, mappingName, sqlInfo);
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: getMapping region: " + mappingName + " size: " + params.length + " time: " + usedTime));
        }
        return obj;
    }

    public Object getExtendMapping(String mappingName, Object[] keys) throws DaoException {
        return this.getMapping((Object)null, mappingName, keys);
    }

    public Object getExtendMapping(Object account_id, String mappingName, Object key) throws DaoException {
        if (key == null) {
            return this.getMapping(account_id, mappingName, new Object[0]);
        }
        return this.getMapping(account_id, mappingName, new Object[]{key});
    }

    public Object getExtendMapping(String mappingName, Object key) throws DaoException {
        return this.getMapping(null, mappingName, key);
    }

    @Override
    public List getMappings(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(mapName);
        DalAssert.assertObjectNotNull(paramsList);
        long t1 = System.currentTimeMillis();
        ArrayList<Object> resList = new ArrayList<Object>();
        try {
            RoutingService.getInstance().setRoutingStrategyForMap(mapName, accountId, paramsList.get(0), 1);
            for (Object[] params : paramsList) {
                SqlInfo sqlInfo = SqlUtil.getMappingSqlInfo(mapName, params, false);
                Object obj = this.dbAgent.getMapping(accountId, mapName, sqlInfo);
                if (obj == null) continue;
                resList.add(obj);
            }
            return resList;
        }
        catch (Exception e) {
            this.processException(e);
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getMappings region: " + mapName + " size: " + paramsList.size() + " time: " + usedTime));
            }
            return resList;
        }
    }

    @Override
    public List getMapList(List accountIdList, String mapname, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(accountIdList);
        DalAssert.assertObjectNotNull(mapname);
        DalAssert.assertObjectNotNull(paramsList);
        ArrayList resList = new ArrayList();
        try {
            String dbName;
            HashMap dbParamsMap = new HashMap();
            HashMap dbAccountMap = new HashMap();
            int index = 0;
            while (index < accountIdList.size()) {
                Object[] params;
                Object accountId = accountIdList.get(index);
                RoutingService.getInstance().setRoutingStrategyForMap(mapname, accountId, paramsList.get(0), 1);
                dbName = ContextHolder.getDataSource();
                if (dbAccountMap.get(dbName) == null) {
                    params = paramsList.get(index);
                    if (params != null) {
                        dbAccountMap.put(dbName, accountId);
                        ArrayList<Object[]> newParamList = new ArrayList<Object[]>();
                        newParamList.add(params);
                        dbParamsMap.put(dbName, newParamList);
                    }
                } else {
                    params = paramsList.get(index);
                    if (params != null) {
                        ((List)dbParamsMap.get(dbName)).add(params);
                    }
                }
                ++index;
            }
            for (Map.Entry entry : dbAccountMap.entrySet()) {
                dbName = (String)entry.getKey();
                List bufList = null;
                List<SqlInfo> sqlInfoLs = SqlUtil.getMapAggreSqlInfos(mapname, (List)dbParamsMap.get(dbName));
                RoutingService.getInstance().setRoutingStrategyForMap(mapname, dbAccountMap.get(dbName), 1);
                for (SqlInfo sqlInfo : sqlInfoLs) {
                    bufList = DBAgentHibernateImpl.getInstance().getObjectList(null, null, sqlInfo);
                    resList.addAll(bufList);
                }
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return resList;
    }

    private void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }

    @Override
    public List getAggrIdList(Object account_id, String list_name, List<Object[]> paramsList, int start, int count) throws DaoException {
        return null;
    }
}

