/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class EntityModel {
    private PersistCatalog catalog;

    protected EntityModel() {
    }

    public final boolean isOpen() {
        return this.catalog != null;
    }

    public final void registerClass(Class persistentClass) {
        if (this.catalog != null) {
            throw new IllegalStateException("Store is already open");
        }
        String className = persistentClass.getName();
        ClassMetadata meta = this.getClassMetadata(className);
        if (meta == null) {
            throw new IllegalArgumentException("Class is not persistent: " + className);
        }
    }

    void setCatalog(PersistCatalog catalog) {
        this.catalog = catalog;
    }

    public abstract ClassMetadata getClassMetadata(String var1);

    public abstract EntityMetadata getEntityMetadata(String var1);

    public abstract Set<String> getKnownClasses();

    public final RawType getRawType(String className) {
        if (this.catalog != null) {
            return this.catalog.getFormat(className);
        }
        throw new IllegalStateException("Store is not open");
    }

    public final RawType getRawTypeVersion(String className, int version) {
        if (this.catalog != null) {
            Format format = this.catalog.getLatestVersion(className);
            while (format != null) {
                if (version != format.getVersion()) continue;
                return format;
            }
            return null;
        }
        throw new IllegalStateException("Store is not open");
    }

    public final List<RawType> getAllRawTypeVersions(String className) {
        if (this.catalog != null) {
            Format format = this.catalog.getLatestVersion(className);
            if (format != null) {
                ArrayList<Format> list = new ArrayList<Format>();
                while (format != null) {
                    list.add(format);
                    format = format.getPreviousVersion();
                }
                return Collections.unmodifiableList(list);
            }
            return null;
        }
        throw new IllegalStateException("Store is not open");
    }

    public final List<RawType> getAllRawTypes() {
        if (this.catalog != null) {
            return this.catalog.getAllRawTypes();
        }
        throw new IllegalStateException("Store is not open");
    }

    public final Object convertRawObject(RawObject raw) {
        return this.catalog.convertRawObject(raw, null);
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return Class.forName(className);
        }
    }
}

