/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.model.EntityModel;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class SimpleFormat
extends Format {
    private static final long serialVersionUID = 4595245575868697702L;
    private boolean primitive;
    private SimpleFormat wrapperFormat;

    SimpleFormat(Class type, boolean primitive) {
        super(type);
        this.primitive = primitive;
    }

    void setWrapperFormat(SimpleFormat wrapperFormat) {
        this.wrapperFormat = wrapperFormat;
    }

    @Override
    Format getWrapperFormat() {
        return this.wrapperFormat;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        return o;
    }

    @Override
    boolean evolve(Format newFormat, Evolver evolver) {
        evolver.useOldFormat(this, newFormat);
        return true;
    }

    Object newPrimitiveArray(int len, EntityInput input) {
        throw new UnsupportedOperationException();
    }

    void writePrimitiveArray(Object o, EntityOutput output) {
        throw new UnsupportedOperationException();
    }

    int getPrimitiveLength() {
        throw new UnsupportedOperationException();
    }

    void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    void skipPrimitiveArray(int len, RecordInput input) {
        input.skipFast(len * this.getPrimitiveLength());
    }

    void copySecMultiKeyPrimitiveArray(int len, RecordInput input, Set results) {
        int primLen = this.getPrimitiveLength();
        int i = 0;
        while (i < len) {
            DatabaseEntry entry = new DatabaseEntry(input.getBufferBytes(), input.getBufferOffset(), primLen);
            results.add(entry);
            input.skipFast(primLen);
            ++i;
        }
    }

    public static class FBigInt
    extends SimpleFormat {
        private static final long serialVersionUID = -5027098112507644563L;

        FBigInt() {
            super(BigInteger.class, false);
        }

        @Override
        Object newArray(int len) {
            return new BigInteger[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readBigInteger();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeBigInteger((BigInteger)o);
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(input.getBigIntegerByteLength());
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            int len = input.getBigIntegerByteLength();
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
            input.skipFast(len);
        }
    }

    public static class FBool
    extends SimpleFormat {
        private static final long serialVersionUID = -7724949525068533451L;

        FBool(boolean primitive) {
            super(primitive ? Boolean.TYPE : Boolean.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Boolean[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readBoolean();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeBoolean((Boolean)o);
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(1);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            boolean[] a = new boolean[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readBoolean();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            boolean[] a = (boolean[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeBoolean(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 1;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setBoolean(o, input.readBoolean());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeBoolean(field.getBoolean(o));
        }
    }

    public static class FByte
    extends SimpleFormat {
        private static final long serialVersionUID = 3651752958101447257L;

        FByte(boolean primitive) {
            super(primitive ? Byte.TYPE : Byte.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Byte[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readByte();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeByte(((Number)o).byteValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(1);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            byte[] a = new byte[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readByte();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            byte[] a = (byte[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeByte(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 1;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setByte(o, input.readByte());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeByte(field.getByte(o));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FChar
    extends SimpleFormat {
        private static final long serialVersionUID = -7609118195770005374L;

        FChar(boolean primitive) {
            super(primitive ? Character.TYPE : Character.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Character[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return Character.valueOf(input.readChar());
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeChar(((Character)o).charValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(2);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            char[] a = new char[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readChar();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            char[] a = (char[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeChar(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 2;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setChar(o, input.readChar());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeChar(field.getChar(o));
        }
    }

    public static class FDate
    extends SimpleFormat {
        private static final long serialVersionUID = -5665773229869034145L;

        FDate() {
            super(Date.class, false);
        }

        @Override
        Object newArray(int len) {
            return new Date[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return new Date(input.readLong());
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeLong(((Date)o).getTime());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(8);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }
    }

    public static class FDouble
    extends SimpleFormat {
        private static final long serialVersionUID = 646904456811041423L;

        FDouble(boolean primitive) {
            super(primitive ? Double.TYPE : Double.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Double[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readSortedDouble();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedDouble(((Number)o).doubleValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(8);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            double[] a = new double[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readSortedDouble();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            double[] a = (double[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeSortedDouble(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 8;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setDouble(o, input.readSortedDouble());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeSortedDouble(field.getDouble(o));
        }
    }

    public static class FFloat
    extends SimpleFormat {
        private static final long serialVersionUID = 1033413049495053602L;

        FFloat(boolean primitive) {
            super(primitive ? Float.TYPE : Float.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Float[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return Float.valueOf(input.readSortedFloat());
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedFloat(((Number)o).floatValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(4);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            float[] a = new float[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readSortedFloat();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            float[] a = (float[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeSortedFloat(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 4;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setFloat(o, input.readSortedFloat());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeSortedFloat(field.getFloat(o));
        }
    }

    public static class FInt
    extends SimpleFormat {
        private static final long serialVersionUID = 2695910006049980013L;

        FInt(boolean primitive) {
            super(primitive ? Integer.TYPE : Integer.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Integer[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readInt();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeInt(((Number)o).intValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(4);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            int[] a = new int[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readInt();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            int[] a = (int[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeInt(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 4;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setInt(o, input.readInt());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeInt(field.getInt(o));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FLong
    extends SimpleFormat {
        private static final long serialVersionUID = 1872661106534776520L;

        FLong(boolean primitive) {
            super(primitive ? Long.TYPE : Long.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Long[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readLong();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeLong(((Number)o).longValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(8);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            long[] a = new long[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readLong();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            long[] a = (long[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeLong(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 8;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setLong(o, input.readLong());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeLong(field.getLong(o));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FShort
    extends SimpleFormat {
        private static final long serialVersionUID = -4909138198491785624L;

        FShort(boolean primitive) {
            super(primitive ? Short.TYPE : Short.class, primitive);
        }

        @Override
        Object newArray(int len) {
            return new Short[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readShort();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeShort(((Number)o).shortValue());
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(2);
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        @Override
        Object newPrimitiveArray(int len, EntityInput input) {
            short[] a = new short[len];
            int i = 0;
            while (i < len) {
                a[i] = input.readShort();
                ++i;
            }
            return a;
        }

        @Override
        void writePrimitiveArray(Object o, EntityOutput output) {
            short[] a = (short[])o;
            int len = a.length;
            output.writeArrayLength(len);
            int i = 0;
            while (i < len) {
                output.writeShort(a[i]);
                ++i;
            }
        }

        @Override
        int getPrimitiveLength() {
            return 2;
        }

        @Override
        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException {
            field.setShort(o, input.readShort());
        }

        @Override
        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeShort(field.getShort(o));
        }

        @Override
        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FString
    extends SimpleFormat {
        private static final long serialVersionUID = 5710392786480064612L;

        FString() {
            super(String.class, false);
        }

        @Override
        Object newArray(int len) {
            return new String[len];
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return input.readString();
        }

        @Override
        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeString((String)o);
        }

        @Override
        void skipContents(RecordInput input) {
            input.skipFast(input.getStringByteLength());
        }

        @Override
        void copySecKey(RecordInput input, RecordOutput output) {
            int len = input.getStringByteLength();
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
            input.skipFast(len);
        }
    }
}

