/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawArrayInput;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class PrimitiveArrayFormat
extends Format {
    private static final long serialVersionUID = 8285299924106073591L;
    private SimpleFormat componentFormat;

    PrimitiveArrayFormat(Class type) {
        super(type);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimensions() {
        return 1;
    }

    @Override
    public Format getComponentType() {
        return this.componentFormat;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        this.componentFormat = (SimpleFormat)catalog.getFormat(this.getExistingType().getComponentType(), false);
    }

    @Override
    Object newArray(int len) {
        return Array.newInstance(this.getType(), len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        int len = input.readArrayLength();
        if (rawAccess) {
            return new RawObject((RawType)this, new Object[len]);
        }
        return this.componentFormat.newPrimitiveArray(len, input);
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        if (rawAccess) {
            Object[] a = ((RawObject)o).getElements();
            int i = 0;
            while (i < a.length) {
                a[i] = this.componentFormat.newInstance(input, true);
                this.componentFormat.readObject(a[i], input, true);
                ++i;
            }
        }
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        if (rawAccess) {
            Object[] a = ((RawObject)o).getElements();
            output.writeArrayLength(a.length);
            int i = 0;
            while (i < a.length) {
                this.componentFormat.writeObject(a[i], output, true);
                ++i;
            }
        } else {
            this.componentFormat.writePrimitiveArray(o, output);
        }
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        RawArrayInput input = new RawArrayInput(catalog, rawAccess, converted, rawObject, this.componentFormat);
        Object a = this.newInstance(input, rawAccess);
        converted.put(rawObject, a);
        return this.readObject(a, input, rawAccess);
    }

    @Override
    void skipContents(RecordInput input) {
        int len = input.readPackedInt();
        this.componentFormat.skipPrimitiveArray(len, input);
    }

    @Override
    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) {
        int len = input.readPackedInt();
        this.componentFormat.copySecMultiKeyPrimitiveArray(len, input, results);
    }

    @Override
    boolean evolve(Format newFormat, Evolver evolver) {
        evolver.useOldFormat(this, newFormat);
        return true;
    }
}

