/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.util.Set;

public class LatchedLockManager
extends LockManager {
    public LatchedLockManager(EnvironmentImpl envImpl) throws DatabaseException {
        super(envImpl);
    }

    @Override
    protected Lock lookupLock(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Lock lock = this.lookupLockInternal(nodeId, lockTableIndex);
            return lock;
        }
        finally {
            latch.release();
        }
    }

    @Override
    protected LockAttemptResult attemptLock(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            LockAttemptResult lockAttemptResult = this.attemptLockInternal(nodeId, locker, type, nonBlockingRequest, lockTableIndex);
            return lockAttemptResult;
        }
        finally {
            latch.release();
        }
    }

    @Override
    protected DeadlockException makeTimeoutMsg(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            DeadlockException deadlockException = this.makeTimeoutMsgInternal(lockOrTxn, locker, nodeId, type, grantType, useLock, timeout, start, now, database);
            return deadlockException;
        }
        finally {
            latch.release();
        }
    }

    @Override
    protected Set<Locker> releaseAndFindNotifyTargets(long nodeId, Locker locker) throws DatabaseException {
        long nid = nodeId;
        int lockTableIndex = this.getLockTableIndex(nid);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Set<Locker> set = this.releaseAndFindNotifyTargetsInternal(nodeId, locker, lockTableIndex);
            return set;
        }
        finally {
            latch.release();
        }
    }

    @Override
    void transfer(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferInternal(nodeId, owningLocker, destLocker, demoteToRead, lockTableIndex);
        }
        finally {
            latch.release();
        }
    }

    @Override
    void transferMultiple(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferMultipleInternal(nodeId, owningLocker, destLockers, lockTableIndex);
        }
        finally {
            latch.release();
        }
    }

    @Override
    void demote(long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.demoteInternal(nodeId, locker, lockTableIndex);
        }
        finally {
            latch.release();
        }
    }

    @Override
    boolean isLocked(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isLockedInternal(nodeId, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    @Override
    boolean isOwner(Long nodeId, Locker locker, LockType type) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isOwnerInternal(nodeId, locker, type, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    @Override
    boolean isWaiter(Long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isWaiterInternal(nodeId, locker, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    @Override
    int nWaiters(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            int n = this.nWaitersInternal(nodeId, lockTableIndex);
            return n;
        }
        finally {
            latch.release();
        }
    }

    @Override
    int nOwners(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            int n = this.nOwnersInternal(nodeId, lockTableIndex);
            return n;
        }
        finally {
            latch.release();
        }
    }

    @Override
    Locker getWriteOwnerLocker(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Locker locker = this.getWriteOwnerLockerInternal(nodeId, lockTableIndex);
            return locker;
        }
        finally {
            latch.release();
        }
    }

    @Override
    protected boolean validateOwnership(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.validateOwnershipInternal(nodeId, locker, type, flushFromWaiters, mb, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    @Override
    protected void dumpLockTable(LockStats stats) throws DatabaseException {
        int i = 0;
        while (i < this.nLockTables) {
            this.lockTableLatches[i].acquire();
            try {
                this.dumpLockTableInternal(stats, i);
            }
            finally {
                this.lockTableLatches[i].release();
            }
            ++i;
        }
    }
}

